/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.BackupDestinationSummary;
import com.oracle.bmc.database.requests.ListBackupDestinationRequest;
import com.oracle.bmc.database.responses.ListBackupDestinationResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBackupDestinationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListBackupDestinationConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListBackupDestinationRequest interceptRequest(ListBackupDestinationRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListBackupDestinationRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("backupDestinations");
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getType() != null) {
            target = target.queryParam("type", HttpUtils.attemptEncodeQueryParam(request.getType()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListBackupDestinationResponse> fromResponse() {
        Function<Response, ListBackupDestinationResponse> transformer = new Function<Response, ListBackupDestinationResponse>(){

            public ListBackupDestinationResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for ListBackupDestinationResponse");
                Function<Response, WithHeaders<List<BackupDestinationSummary>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<BackupDestinationSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListBackupDestinationResponse.Builder builder = ListBackupDestinationResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListBackupDestinationResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

