/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.VmClusterNetworkSummary;
import com.oracle.bmc.database.requests.ListVmClusterNetworksRequest;
import com.oracle.bmc.database.responses.ListVmClusterNetworksResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListVmClusterNetworksConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListVmClusterNetworksConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListVmClusterNetworksRequest interceptRequest(ListVmClusterNetworksRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListVmClusterNetworksRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getExadataInfrastructureId(), (String)"exadataInfrastructureId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("exadataInfrastructures").path(HttpUtils.encodePathSegment(request.getExadataInfrastructureId())).path("vmClusterNetworks");
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", HttpUtils.attemptEncodeQueryParam(request.getSortBy().getValue()));
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", HttpUtils.attemptEncodeQueryParam(request.getSortOrder().getValue()));
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", HttpUtils.attemptEncodeQueryParam(request.getLifecycleState().getValue()));
        }
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", HttpUtils.attemptEncodeQueryParam(request.getDisplayName()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListVmClusterNetworksResponse> fromResponse() {
        Function<Response, ListVmClusterNetworksResponse> transformer = new Function<Response, ListVmClusterNetworksResponse>(){

            public ListVmClusterNetworksResponse apply(Response rawResponse) {
                Optional<List<String>> opcNextPageHeader;
                LOG.trace("Transform function invoked for ListVmClusterNetworksResponse");
                Function<Response, WithHeaders<List<VmClusterNetworkSummary>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<VmClusterNetworkSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListVmClusterNetworksResponse.Builder builder = ListVmClusterNetworksResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page")).isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                ListVmClusterNetworksResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

