/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.AutonomousDataWarehouse;
import com.oracle.bmc.database.requests.RestoreAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.responses.RestoreAutonomousDataWarehouseResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreAutonomousDataWarehouseConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreAutonomousDataWarehouseConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static RestoreAutonomousDataWarehouseRequest interceptRequest(RestoreAutonomousDataWarehouseRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, RestoreAutonomousDataWarehouseRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutonomousDataWarehouseId(), (String)"autonomousDataWarehouseId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getRestoreAutonomousDataWarehouseDetails(), (String)"restoreAutonomousDataWarehouseDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("autonomousDataWarehouses").path(HttpUtils.encodePathSegment(request.getAutonomousDataWarehouseId())).path("actions").path("restore");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, RestoreAutonomousDataWarehouseResponse> fromResponse() {
        Function<Response, RestoreAutonomousDataWarehouseResponse> transformer = new Function<Response, RestoreAutonomousDataWarehouseResponse>(){

            public RestoreAutonomousDataWarehouseResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for RestoreAutonomousDataWarehouseResponse");
                Function<Response, WithHeaders<AutonomousDataWarehouse>> responseFn = RESPONSE_CONVERSION_FACTORY.create(AutonomousDataWarehouse.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                RestoreAutonomousDataWarehouseResponse.Builder builder = RestoreAutonomousDataWarehouseResponse.builder();
                builder.autonomousDataWarehouse((AutonomousDataWarehouse)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                RestoreAutonomousDataWarehouseResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

