/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.AutonomousContainerDatabase;
import com.oracle.bmc.database.requests.UpdateAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.responses.UpdateAutonomousContainerDatabaseResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAutonomousContainerDatabaseConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateAutonomousContainerDatabaseConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateAutonomousContainerDatabaseRequest interceptRequest(UpdateAutonomousContainerDatabaseRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateAutonomousContainerDatabaseRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutonomousContainerDatabaseId(), (String)"autonomousContainerDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateAutonomousContainerDatabaseDetails(), (String)"updateAutonomousContainerDatabaseDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("autonomousContainerDatabases").path(HttpUtils.encodePathSegment(request.getAutonomousContainerDatabaseId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpdateAutonomousContainerDatabaseResponse> fromResponse() {
        Function<Response, UpdateAutonomousContainerDatabaseResponse> transformer = new Function<Response, UpdateAutonomousContainerDatabaseResponse>(){

            public UpdateAutonomousContainerDatabaseResponse apply(Response rawResponse) {
                Optional<List<String>> opcWorkRequestIdHeader;
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for UpdateAutonomousContainerDatabaseResponse");
                Function<Response, WithHeaders<AutonomousContainerDatabase>> responseFn = RESPONSE_CONVERSION_FACTORY.create(AutonomousContainerDatabase.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateAutonomousContainerDatabaseResponse.Builder builder = UpdateAutonomousContainerDatabaseResponse.builder();
                builder.autonomousContainerDatabase((AutonomousContainerDatabase)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get(headers, "opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId(HeaderUtils.toValue("opc-work-request-id", (String)((List)opcWorkRequestIdHeader.get()).get(0), String.class));
                }
                UpdateAutonomousContainerDatabaseResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

