/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbNode {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="dbSystemId")
    private final String dbSystemId;
    @JsonProperty(value="vnicId")
    private final String vnicId;
    @JsonProperty(value="backupVnicId")
    private final String backupVnicId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="softwareStorageSizeInGB")
    private final Integer softwareStorageSizeInGB;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getVnicId() {
        return this.vnicId;
    }

    public String getBackupVnicId() {
        return this.backupVnicId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Integer getSoftwareStorageSizeInGB() {
        return this.softwareStorageSizeInGB;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbNode)) {
            return false;
        }
        DbNode other = (DbNode)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$dbSystemId = this.getDbSystemId();
        String other$dbSystemId = other.getDbSystemId();
        if (this$dbSystemId == null ? other$dbSystemId != null : !this$dbSystemId.equals(other$dbSystemId)) {
            return false;
        }
        String this$vnicId = this.getVnicId();
        String other$vnicId = other.getVnicId();
        if (this$vnicId == null ? other$vnicId != null : !this$vnicId.equals(other$vnicId)) {
            return false;
        }
        String this$backupVnicId = this.getBackupVnicId();
        String other$backupVnicId = other.getBackupVnicId();
        if (this$backupVnicId == null ? other$backupVnicId != null : !this$backupVnicId.equals(other$backupVnicId)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$faultDomain = this.getFaultDomain();
        String other$faultDomain = other.getFaultDomain();
        if (this$faultDomain == null ? other$faultDomain != null : !this$faultDomain.equals(other$faultDomain)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        Integer this$softwareStorageSizeInGB = this.getSoftwareStorageSizeInGB();
        Integer other$softwareStorageSizeInGB = other.getSoftwareStorageSizeInGB();
        if (this$softwareStorageSizeInGB == null ? other$softwareStorageSizeInGB != null : !((Object)this$softwareStorageSizeInGB).equals(other$softwareStorageSizeInGB)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $dbSystemId = this.getDbSystemId();
        result = result * 59 + ($dbSystemId == null ? 43 : $dbSystemId.hashCode());
        String $vnicId = this.getVnicId();
        result = result * 59 + ($vnicId == null ? 43 : $vnicId.hashCode());
        String $backupVnicId = this.getBackupVnicId();
        result = result * 59 + ($backupVnicId == null ? 43 : $backupVnicId.hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $faultDomain = this.getFaultDomain();
        result = result * 59 + ($faultDomain == null ? 43 : $faultDomain.hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        Integer $softwareStorageSizeInGB = this.getSoftwareStorageSizeInGB();
        result = result * 59 + ($softwareStorageSizeInGB == null ? 43 : ((Object)$softwareStorageSizeInGB).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "DbNode(id=" + this.getId() + ", dbSystemId=" + this.getDbSystemId() + ", vnicId=" + this.getVnicId() + ", backupVnicId=" + this.getBackupVnicId() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", hostname=" + this.getHostname() + ", faultDomain=" + this.getFaultDomain() + ", timeCreated=" + this.getTimeCreated() + ", softwareStorageSizeInGB=" + this.getSoftwareStorageSizeInGB() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "dbSystemId", "vnicId", "backupVnicId", "lifecycleState", "hostname", "faultDomain", "timeCreated", "softwareStorageSizeInGB"})
    @Deprecated
    public DbNode(String id, String dbSystemId, String vnicId, String backupVnicId, LifecycleState lifecycleState, String hostname, String faultDomain, Date timeCreated, Integer softwareStorageSizeInGB) {
        this.id = id;
        this.dbSystemId = dbSystemId;
        this.vnicId = vnicId;
        this.backupVnicId = backupVnicId;
        this.lifecycleState = lifecycleState;
        this.hostname = hostname;
        this.faultDomain = faultDomain;
        this.timeCreated = timeCreated;
        this.softwareStorageSizeInGB = softwareStorageSizeInGB;
    }

    public static enum LifecycleState {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Stopping("STOPPING"),
        Stopped("STOPPED"),
        Starting("STARTING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="dbSystemId")
        private String dbSystemId;
        @JsonProperty(value="vnicId")
        private String vnicId;
        @JsonProperty(value="backupVnicId")
        private String backupVnicId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="softwareStorageSizeInGB")
        private Integer softwareStorageSizeInGB;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            this.__explicitlySet__.add("dbSystemId");
            return this;
        }

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            this.__explicitlySet__.add("vnicId");
            return this;
        }

        public Builder backupVnicId(String backupVnicId) {
            this.backupVnicId = backupVnicId;
            this.__explicitlySet__.add("backupVnicId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder softwareStorageSizeInGB(Integer softwareStorageSizeInGB) {
            this.softwareStorageSizeInGB = softwareStorageSizeInGB;
            this.__explicitlySet__.add("softwareStorageSizeInGB");
            return this;
        }

        public DbNode build() {
            DbNode __instance__ = new DbNode(this.id, this.dbSystemId, this.vnicId, this.backupVnicId, this.lifecycleState, this.hostname, this.faultDomain, this.timeCreated, this.softwareStorageSizeInGB);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(DbNode o) {
            Builder copiedBuilder = this.id(o.getId()).dbSystemId(o.getDbSystemId()).vnicId(o.getVnicId()).backupVnicId(o.getBackupVnicId()).lifecycleState(o.getLifecycleState()).hostname(o.getHostname()).faultDomain(o.getFaultDomain()).timeCreated(o.getTimeCreated()).softwareStorageSizeInGB(o.getSoftwareStorageSizeInGB());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

