/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InfoForNetworkGenDetails {
    @JsonProperty(value="networkType")
    private final NetworkType networkType;
    @JsonProperty(value="vlanId")
    private final String vlanId;
    @JsonProperty(value="cidr")
    private final String cidr;
    @JsonProperty(value="gateway")
    private final String gateway;
    @JsonProperty(value="netmask")
    private final String netmask;
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="prefix")
    private final String prefix;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public String getVlanId() {
        return this.vlanId;
    }

    public String getCidr() {
        return this.cidr;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfoForNetworkGenDetails)) {
            return false;
        }
        InfoForNetworkGenDetails other = (InfoForNetworkGenDetails)o;
        NetworkType this$networkType = this.getNetworkType();
        NetworkType other$networkType = other.getNetworkType();
        if (this$networkType == null ? other$networkType != null : !((Object)((Object)this$networkType)).equals((Object)other$networkType)) {
            return false;
        }
        String this$vlanId = this.getVlanId();
        String other$vlanId = other.getVlanId();
        if (this$vlanId == null ? other$vlanId != null : !this$vlanId.equals(other$vlanId)) {
            return false;
        }
        String this$cidr = this.getCidr();
        String other$cidr = other.getCidr();
        if (this$cidr == null ? other$cidr != null : !this$cidr.equals(other$cidr)) {
            return false;
        }
        String this$gateway = this.getGateway();
        String other$gateway = other.getGateway();
        if (this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway)) {
            return false;
        }
        String this$netmask = this.getNetmask();
        String other$netmask = other.getNetmask();
        if (this$netmask == null ? other$netmask != null : !this$netmask.equals(other$netmask)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NetworkType $networkType = this.getNetworkType();
        result = result * 59 + ($networkType == null ? 43 : ((Object)((Object)$networkType)).hashCode());
        String $vlanId = this.getVlanId();
        result = result * 59 + ($vlanId == null ? 43 : $vlanId.hashCode());
        String $cidr = this.getCidr();
        result = result * 59 + ($cidr == null ? 43 : $cidr.hashCode());
        String $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
        String $netmask = this.getNetmask();
        result = result * 59 + ($netmask == null ? 43 : $netmask.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "InfoForNetworkGenDetails(networkType=" + (Object)((Object)this.getNetworkType()) + ", vlanId=" + this.getVlanId() + ", cidr=" + this.getCidr() + ", gateway=" + this.getGateway() + ", netmask=" + this.getNetmask() + ", domain=" + this.getDomain() + ", prefix=" + this.getPrefix() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"networkType", "vlanId", "cidr", "gateway", "netmask", "domain", "prefix"})
    @Deprecated
    public InfoForNetworkGenDetails(NetworkType networkType, String vlanId, String cidr, String gateway, String netmask, String domain, String prefix) {
        this.networkType = networkType;
        this.vlanId = vlanId;
        this.cidr = cidr;
        this.gateway = gateway;
        this.netmask = netmask;
        this.domain = domain;
        this.prefix = prefix;
    }

    public static enum NetworkType {
        Client("CLIENT"),
        Backup("BACKUP");

        private final String value;
        private static Map<String, NetworkType> map;

        private NetworkType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NetworkType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid NetworkType: " + key);
        }

        static {
            map = new HashMap<String, NetworkType>();
            for (NetworkType v : NetworkType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="networkType")
        private NetworkType networkType;
        @JsonProperty(value="vlanId")
        private String vlanId;
        @JsonProperty(value="cidr")
        private String cidr;
        @JsonProperty(value="gateway")
        private String gateway;
        @JsonProperty(value="netmask")
        private String netmask;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="prefix")
        private String prefix;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            this.__explicitlySet__.add("networkType");
            return this;
        }

        public Builder vlanId(String vlanId) {
            this.vlanId = vlanId;
            this.__explicitlySet__.add("vlanId");
            return this;
        }

        public Builder cidr(String cidr) {
            this.cidr = cidr;
            this.__explicitlySet__.add("cidr");
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            this.__explicitlySet__.add("gateway");
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            this.__explicitlySet__.add("netmask");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.__explicitlySet__.add("prefix");
            return this;
        }

        public InfoForNetworkGenDetails build() {
            InfoForNetworkGenDetails __instance__ = new InfoForNetworkGenDetails(this.networkType, this.vlanId, this.cidr, this.gateway, this.netmask, this.domain, this.prefix);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(InfoForNetworkGenDetails o) {
            Builder copiedBuilder = this.networkType(o.getNetworkType()).vlanId(o.getVlanId()).cidr(o.getCidr()).gateway(o.getGateway()).netmask(o.getNetmask()).domain(o.getDomain()).prefix(o.getPrefix());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

