/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.NodeDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VmNetworkDetails {
    @JsonProperty(value="vlanId")
    private final String vlanId;
    @JsonProperty(value="networkType")
    private final NetworkType networkType;
    @JsonProperty(value="netmask")
    private final String netmask;
    @JsonProperty(value="gateway")
    private final String gateway;
    @JsonProperty(value="domainName")
    private final String domainName;
    @JsonProperty(value="nodes")
    private final List<NodeDetails> nodes;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public String getVlanId() {
        return this.vlanId;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public List<NodeDetails> getNodes() {
        return this.nodes;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmNetworkDetails)) {
            return false;
        }
        VmNetworkDetails other = (VmNetworkDetails)o;
        String this$vlanId = this.getVlanId();
        String other$vlanId = other.getVlanId();
        if (this$vlanId == null ? other$vlanId != null : !this$vlanId.equals(other$vlanId)) {
            return false;
        }
        NetworkType this$networkType = this.getNetworkType();
        NetworkType other$networkType = other.getNetworkType();
        if (this$networkType == null ? other$networkType != null : !((Object)((Object)this$networkType)).equals((Object)other$networkType)) {
            return false;
        }
        String this$netmask = this.getNetmask();
        String other$netmask = other.getNetmask();
        if (this$netmask == null ? other$netmask != null : !this$netmask.equals(other$netmask)) {
            return false;
        }
        String this$gateway = this.getGateway();
        String other$gateway = other.getGateway();
        if (this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway)) {
            return false;
        }
        String this$domainName = this.getDomainName();
        String other$domainName = other.getDomainName();
        if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
            return false;
        }
        List<NodeDetails> this$nodes = this.getNodes();
        List<NodeDetails> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $vlanId = this.getVlanId();
        result = result * 59 + ($vlanId == null ? 43 : $vlanId.hashCode());
        NetworkType $networkType = this.getNetworkType();
        result = result * 59 + ($networkType == null ? 43 : ((Object)((Object)$networkType)).hashCode());
        String $netmask = this.getNetmask();
        result = result * 59 + ($netmask == null ? 43 : $netmask.hashCode());
        String $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
        String $domainName = this.getDomainName();
        result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
        List<NodeDetails> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "VmNetworkDetails(vlanId=" + this.getVlanId() + ", networkType=" + (Object)((Object)this.getNetworkType()) + ", netmask=" + this.getNetmask() + ", gateway=" + this.getGateway() + ", domainName=" + this.getDomainName() + ", nodes=" + this.getNodes() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"vlanId", "networkType", "netmask", "gateway", "domainName", "nodes"})
    @Deprecated
    public VmNetworkDetails(String vlanId, NetworkType networkType, String netmask, String gateway, String domainName, List<NodeDetails> nodes) {
        this.vlanId = vlanId;
        this.networkType = networkType;
        this.netmask = netmask;
        this.gateway = gateway;
        this.domainName = domainName;
        this.nodes = nodes;
    }

    public static enum NetworkType {
        Client("CLIENT"),
        Backup("BACKUP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, NetworkType> map;

        private NetworkType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NetworkType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'NetworkType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(NetworkType.class);
            map = new HashMap<String, NetworkType>();
            for (NetworkType v : NetworkType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vlanId")
        private String vlanId;
        @JsonProperty(value="networkType")
        private NetworkType networkType;
        @JsonProperty(value="netmask")
        private String netmask;
        @JsonProperty(value="gateway")
        private String gateway;
        @JsonProperty(value="domainName")
        private String domainName;
        @JsonProperty(value="nodes")
        private List<NodeDetails> nodes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vlanId(String vlanId) {
            this.vlanId = vlanId;
            this.__explicitlySet__.add("vlanId");
            return this;
        }

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            this.__explicitlySet__.add("networkType");
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            this.__explicitlySet__.add("netmask");
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            this.__explicitlySet__.add("gateway");
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            this.__explicitlySet__.add("domainName");
            return this;
        }

        public Builder nodes(List<NodeDetails> nodes) {
            this.nodes = nodes;
            this.__explicitlySet__.add("nodes");
            return this;
        }

        public VmNetworkDetails build() {
            VmNetworkDetails __instance__ = new VmNetworkDetails(this.vlanId, this.networkType, this.netmask, this.gateway, this.domainName, this.nodes);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(VmNetworkDetails o) {
            Builder copiedBuilder = this.vlanId(o.getVlanId()).networkType(o.getNetworkType()).netmask(o.getNetmask()).gateway(o.getGateway()).domainName(o.getDomainName()).nodes(o.getNodes());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

