/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDbHomeRequest
extends BmcRequest {
    private String dbHomeId;
    private String ifMatch;
    private Boolean performFinalBackup;

    @ConstructorProperties(value={"dbHomeId", "ifMatch", "performFinalBackup"})
    DeleteDbHomeRequest(String dbHomeId, String ifMatch, Boolean performFinalBackup) {
        this.dbHomeId = dbHomeId;
        this.ifMatch = ifMatch;
        this.performFinalBackup = performFinalBackup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbHomeId() {
        return this.dbHomeId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Boolean getPerformFinalBackup() {
        return this.performFinalBackup;
    }

    public static class Builder {
        private String dbHomeId;
        private String ifMatch;
        private Boolean performFinalBackup;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDbHomeRequest o) {
            this.dbHomeId(o.getDbHomeId());
            this.ifMatch(o.getIfMatch());
            this.performFinalBackup(o.getPerformFinalBackup());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDbHomeRequest build() {
            DeleteDbHomeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder performFinalBackup(Boolean performFinalBackup) {
            this.performFinalBackup = performFinalBackup;
            return this;
        }

        public DeleteDbHomeRequest buildWithoutInvocationCallback() {
            return new DeleteDbHomeRequest(this.dbHomeId, this.ifMatch, this.performFinalBackup);
        }

        public String toString() {
            return "DeleteDbHomeRequest.Builder(dbHomeId=" + this.dbHomeId + ", ifMatch=" + this.ifMatch + ", performFinalBackup=" + this.performFinalBackup + ")";
        }
    }
}

