/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.database.model.FailoverDataGuardAssociationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class FailoverDataGuardAssociationRequest
extends BmcRequest {
    private String databaseId;
    private String dataGuardAssociationId;
    private FailoverDataGuardAssociationDetails failoverDataGuardAssociationDetails;
    private String ifMatch;

    @ConstructorProperties(value={"databaseId", "dataGuardAssociationId", "failoverDataGuardAssociationDetails", "ifMatch"})
    FailoverDataGuardAssociationRequest(String databaseId, String dataGuardAssociationId, FailoverDataGuardAssociationDetails failoverDataGuardAssociationDetails, String ifMatch) {
        this.databaseId = databaseId;
        this.dataGuardAssociationId = dataGuardAssociationId;
        this.failoverDataGuardAssociationDetails = failoverDataGuardAssociationDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDataGuardAssociationId() {
        return this.dataGuardAssociationId;
    }

    public FailoverDataGuardAssociationDetails getFailoverDataGuardAssociationDetails() {
        return this.failoverDataGuardAssociationDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String databaseId;
        private String dataGuardAssociationId;
        private FailoverDataGuardAssociationDetails failoverDataGuardAssociationDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(FailoverDataGuardAssociationRequest o) {
            this.databaseId(o.getDatabaseId());
            this.dataGuardAssociationId(o.getDataGuardAssociationId());
            this.failoverDataGuardAssociationDetails(o.getFailoverDataGuardAssociationDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public FailoverDataGuardAssociationRequest build() {
            FailoverDataGuardAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder dataGuardAssociationId(String dataGuardAssociationId) {
            this.dataGuardAssociationId = dataGuardAssociationId;
            return this;
        }

        public Builder failoverDataGuardAssociationDetails(FailoverDataGuardAssociationDetails failoverDataGuardAssociationDetails) {
            this.failoverDataGuardAssociationDetails = failoverDataGuardAssociationDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public FailoverDataGuardAssociationRequest buildWithoutInvocationCallback() {
            return new FailoverDataGuardAssociationRequest(this.databaseId, this.dataGuardAssociationId, this.failoverDataGuardAssociationDetails, this.ifMatch);
        }

        public String toString() {
            return "FailoverDataGuardAssociationRequest.Builder(databaseId=" + this.databaseId + ", dataGuardAssociationId=" + this.dataGuardAssociationId + ", failoverDataGuardAssociationDetails=" + this.failoverDataGuardAssociationDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

