/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDbNodeRequest
extends BmcRequest {
    private String dbNodeId;

    @ConstructorProperties(value={"dbNodeId"})
    GetDbNodeRequest(String dbNodeId) {
        this.dbNodeId = dbNodeId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbNodeId() {
        return this.dbNodeId;
    }

    public static class Builder {
        private String dbNodeId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbNodeRequest o) {
            this.dbNodeId(o.getDbNodeId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbNodeRequest build() {
            GetDbNodeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public GetDbNodeRequest buildWithoutInvocationCallback() {
            return new GetDbNodeRequest(this.dbNodeId);
        }

        public String toString() {
            return "GetDbNodeRequest.Builder(dbNodeId=" + this.dbNodeId + ")";
        }
    }
}

