/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetExadataInfrastructureRequest
extends BmcRequest {
    private String exadataInfrastructureId;
    private String opcRequestId;

    @ConstructorProperties(value={"exadataInfrastructureId", "opcRequestId"})
    GetExadataInfrastructureRequest(String exadataInfrastructureId, String opcRequestId) {
        this.exadataInfrastructureId = exadataInfrastructureId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getExadataInfrastructureId() {
        return this.exadataInfrastructureId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String exadataInfrastructureId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExadataInfrastructureRequest o) {
            this.exadataInfrastructureId(o.getExadataInfrastructureId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExadataInfrastructureRequest build() {
            GetExadataInfrastructureRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder exadataInfrastructureId(String exadataInfrastructureId) {
            this.exadataInfrastructureId = exadataInfrastructureId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetExadataInfrastructureRequest buildWithoutInvocationCallback() {
            return new GetExadataInfrastructureRequest(this.exadataInfrastructureId, this.opcRequestId);
        }

        public String toString() {
            return "GetExadataInfrastructureRequest.Builder(exadataInfrastructureId=" + this.exadataInfrastructureId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

