/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetExternalBackupJobRequest
extends BmcRequest {
    private String backupId;

    @ConstructorProperties(value={"backupId"})
    GetExternalBackupJobRequest(String backupId) {
        this.backupId = backupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBackupId() {
        return this.backupId;
    }

    public static class Builder {
        private String backupId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalBackupJobRequest o) {
            this.backupId(o.getBackupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalBackupJobRequest build() {
            GetExternalBackupJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public GetExternalBackupJobRequest buildWithoutInvocationCallback() {
            return new GetExternalBackupJobRequest(this.backupId);
        }

        public String toString() {
            return "GetExternalBackupJobRequest.Builder(backupId=" + this.backupId + ")";
        }
    }
}

