/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetVmClusterRequest
extends BmcRequest {
    private String vmClusterId;
    private String opcRequestId;

    @ConstructorProperties(value={"vmClusterId", "opcRequestId"})
    GetVmClusterRequest(String vmClusterId, String opcRequestId) {
        this.vmClusterId = vmClusterId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String vmClusterId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVmClusterRequest o) {
            this.vmClusterId(o.getVmClusterId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVmClusterRequest build() {
            GetVmClusterRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetVmClusterRequest buildWithoutInvocationCallback() {
            return new GetVmClusterRequest(this.vmClusterId, this.opcRequestId);
        }

        public String toString() {
            return "GetVmClusterRequest.Builder(vmClusterId=" + this.vmClusterId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

