/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.database.model.LaunchDbSystemBase;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class LaunchDbSystemRequest
extends BmcRequest {
    private LaunchDbSystemBase launchDbSystemDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"launchDbSystemDetails", "opcRetryToken"})
    LaunchDbSystemRequest(LaunchDbSystemBase launchDbSystemDetails, String opcRetryToken) {
        this.launchDbSystemDetails = launchDbSystemDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LaunchDbSystemBase getLaunchDbSystemDetails() {
        return this.launchDbSystemDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private LaunchDbSystemBase launchDbSystemDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(LaunchDbSystemRequest o) {
            this.launchDbSystemDetails(o.getLaunchDbSystemDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public LaunchDbSystemRequest build() {
            LaunchDbSystemRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder launchDbSystemDetails(LaunchDbSystemBase launchDbSystemDetails) {
            this.launchDbSystemDetails = launchDbSystemDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public LaunchDbSystemRequest buildWithoutInvocationCallback() {
            return new LaunchDbSystemRequest(this.launchDbSystemDetails, this.opcRetryToken);
        }

        public String toString() {
            return "LaunchDbSystemRequest.Builder(launchDbSystemDetails=" + this.launchDbSystemDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

