/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.AutonomousDatabaseSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListAutonomousDatabasesRequest
extends BmcRequest {
    private String compartmentId;
    private String autonomousContainerDatabaseId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private AutonomousDatabaseSummary.LifecycleState lifecycleState;
    private AutonomousDatabaseSummary.DbWorkload dbWorkload;
    private Boolean isFreeTier;
    private String displayName;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "autonomousContainerDatabaseId", "limit", "page", "sortBy", "sortOrder", "lifecycleState", "dbWorkload", "isFreeTier", "displayName", "opcRequestId"})
    ListAutonomousDatabasesRequest(String compartmentId, String autonomousContainerDatabaseId, Integer limit, String page, SortBy sortBy, SortOrder sortOrder, AutonomousDatabaseSummary.LifecycleState lifecycleState, AutonomousDatabaseSummary.DbWorkload dbWorkload, Boolean isFreeTier, String displayName, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.lifecycleState = lifecycleState;
        this.dbWorkload = dbWorkload;
        this.isFreeTier = isFreeTier;
        this.displayName = displayName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAutonomousContainerDatabaseId() {
        return this.autonomousContainerDatabaseId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public AutonomousDatabaseSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public AutonomousDatabaseSummary.DbWorkload getDbWorkload() {
        return this.dbWorkload;
    }

    public Boolean getIsFreeTier() {
        return this.isFreeTier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String compartmentId;
        private String autonomousContainerDatabaseId;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private AutonomousDatabaseSummary.LifecycleState lifecycleState;
        private AutonomousDatabaseSummary.DbWorkload dbWorkload;
        private Boolean isFreeTier;
        private String displayName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAutonomousDatabasesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.autonomousContainerDatabaseId(o.getAutonomousContainerDatabaseId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.dbWorkload(o.getDbWorkload());
            this.isFreeTier(o.getIsFreeTier());
            this.displayName(o.getDisplayName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAutonomousDatabasesRequest build() {
            ListAutonomousDatabasesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder autonomousContainerDatabaseId(String autonomousContainerDatabaseId) {
            this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(AutonomousDatabaseSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder dbWorkload(AutonomousDatabaseSummary.DbWorkload dbWorkload) {
            this.dbWorkload = dbWorkload;
            return this;
        }

        public Builder isFreeTier(Boolean isFreeTier) {
            this.isFreeTier = isFreeTier;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListAutonomousDatabasesRequest buildWithoutInvocationCallback() {
            return new ListAutonomousDatabasesRequest(this.compartmentId, this.autonomousContainerDatabaseId, this.limit, this.page, this.sortBy, this.sortOrder, this.lifecycleState, this.dbWorkload, this.isFreeTier, this.displayName, this.opcRequestId);
        }

        public String toString() {
            return "ListAutonomousDatabasesRequest.Builder(compartmentId=" + this.compartmentId + ", autonomousContainerDatabaseId=" + this.autonomousContainerDatabaseId + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", dbWorkload=" + (Object)((Object)this.dbWorkload) + ", isFreeTier=" + this.isFreeTier + ", displayName=" + this.displayName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

