/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListBackupsRequest
extends BmcRequest {
    private String databaseId;
    private String compartmentId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"databaseId", "compartmentId", "limit", "page"})
    ListBackupsRequest(String databaseId, String compartmentId, Integer limit, String page) {
        this.databaseId = databaseId;
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder {
        private String databaseId;
        private String compartmentId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListBackupsRequest o) {
            this.databaseId(o.getDatabaseId());
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListBackupsRequest build() {
            ListBackupsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListBackupsRequest buildWithoutInvocationCallback() {
            return new ListBackupsRequest(this.databaseId, this.compartmentId, this.limit, this.page);
        }

        public String toString() {
            return "ListBackupsRequest.Builder(databaseId=" + this.databaseId + ", compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

