/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.MaintenanceRunSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListMaintenanceRunsRequest
extends BmcRequest {
    private String compartmentId;
    private String targetResourceId;
    private MaintenanceRunSummary.TargetResourceType targetResourceType;
    private MaintenanceRunSummary.MaintenanceType maintenanceType;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private MaintenanceRunSummary.LifecycleState lifecycleState;
    private String availabilityDomain;

    @ConstructorProperties(value={"compartmentId", "targetResourceId", "targetResourceType", "maintenanceType", "limit", "page", "sortBy", "sortOrder", "lifecycleState", "availabilityDomain"})
    ListMaintenanceRunsRequest(String compartmentId, String targetResourceId, MaintenanceRunSummary.TargetResourceType targetResourceType, MaintenanceRunSummary.MaintenanceType maintenanceType, Integer limit, String page, SortBy sortBy, SortOrder sortOrder, MaintenanceRunSummary.LifecycleState lifecycleState, String availabilityDomain) {
        this.compartmentId = compartmentId;
        this.targetResourceId = targetResourceId;
        this.targetResourceType = targetResourceType;
        this.maintenanceType = maintenanceType;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.lifecycleState = lifecycleState;
        this.availabilityDomain = availabilityDomain;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public MaintenanceRunSummary.TargetResourceType getTargetResourceType() {
        return this.targetResourceType;
    }

    public MaintenanceRunSummary.MaintenanceType getMaintenanceType() {
        return this.maintenanceType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public MaintenanceRunSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public static class Builder {
        private String compartmentId;
        private String targetResourceId;
        private MaintenanceRunSummary.TargetResourceType targetResourceType;
        private MaintenanceRunSummary.MaintenanceType maintenanceType;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private MaintenanceRunSummary.LifecycleState lifecycleState;
        private String availabilityDomain;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMaintenanceRunsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.targetResourceId(o.getTargetResourceId());
            this.targetResourceType(o.getTargetResourceType());
            this.maintenanceType(o.getMaintenanceType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMaintenanceRunsRequest build() {
            ListMaintenanceRunsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            return this;
        }

        public Builder targetResourceType(MaintenanceRunSummary.TargetResourceType targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        public Builder maintenanceType(MaintenanceRunSummary.MaintenanceType maintenanceType) {
            this.maintenanceType = maintenanceType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(MaintenanceRunSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public ListMaintenanceRunsRequest buildWithoutInvocationCallback() {
            return new ListMaintenanceRunsRequest(this.compartmentId, this.targetResourceId, this.targetResourceType, this.maintenanceType, this.limit, this.page, this.sortBy, this.sortOrder, this.lifecycleState, this.availabilityDomain);
        }

        public String toString() {
            return "ListMaintenanceRunsRequest.Builder(compartmentId=" + this.compartmentId + ", targetResourceId=" + this.targetResourceId + ", targetResourceType=" + (Object)((Object)this.targetResourceType) + ", maintenanceType=" + (Object)((Object)this.maintenanceType) + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", availabilityDomain=" + this.availabilityDomain + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        TimeScheduled("TIME_SCHEDULED"),
        TimeEnded("TIME_ENDED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

