/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.database.model.ReinstateDataGuardAssociationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ReinstateDataGuardAssociationRequest
extends BmcRequest {
    private String databaseId;
    private String dataGuardAssociationId;
    private ReinstateDataGuardAssociationDetails reinstateDataGuardAssociationDetails;
    private String ifMatch;

    @ConstructorProperties(value={"databaseId", "dataGuardAssociationId", "reinstateDataGuardAssociationDetails", "ifMatch"})
    ReinstateDataGuardAssociationRequest(String databaseId, String dataGuardAssociationId, ReinstateDataGuardAssociationDetails reinstateDataGuardAssociationDetails, String ifMatch) {
        this.databaseId = databaseId;
        this.dataGuardAssociationId = dataGuardAssociationId;
        this.reinstateDataGuardAssociationDetails = reinstateDataGuardAssociationDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDataGuardAssociationId() {
        return this.dataGuardAssociationId;
    }

    public ReinstateDataGuardAssociationDetails getReinstateDataGuardAssociationDetails() {
        return this.reinstateDataGuardAssociationDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String databaseId;
        private String dataGuardAssociationId;
        private ReinstateDataGuardAssociationDetails reinstateDataGuardAssociationDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ReinstateDataGuardAssociationRequest o) {
            this.databaseId(o.getDatabaseId());
            this.dataGuardAssociationId(o.getDataGuardAssociationId());
            this.reinstateDataGuardAssociationDetails(o.getReinstateDataGuardAssociationDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ReinstateDataGuardAssociationRequest build() {
            ReinstateDataGuardAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder dataGuardAssociationId(String dataGuardAssociationId) {
            this.dataGuardAssociationId = dataGuardAssociationId;
            return this;
        }

        public Builder reinstateDataGuardAssociationDetails(ReinstateDataGuardAssociationDetails reinstateDataGuardAssociationDetails) {
            this.reinstateDataGuardAssociationDetails = reinstateDataGuardAssociationDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public ReinstateDataGuardAssociationRequest buildWithoutInvocationCallback() {
            return new ReinstateDataGuardAssociationRequest(this.databaseId, this.dataGuardAssociationId, this.reinstateDataGuardAssociationDetails, this.ifMatch);
        }

        public String toString() {
            return "ReinstateDataGuardAssociationRequest.Builder(databaseId=" + this.databaseId + ", dataGuardAssociationId=" + this.dataGuardAssociationId + ", reinstateDataGuardAssociationDetails=" + this.reinstateDataGuardAssociationDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

