/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.database.model.RestoreDatabaseDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class RestoreDatabaseRequest
extends BmcRequest {
    private String databaseId;
    private RestoreDatabaseDetails restoreDatabaseDetails;
    private String ifMatch;

    @ConstructorProperties(value={"databaseId", "restoreDatabaseDetails", "ifMatch"})
    RestoreDatabaseRequest(String databaseId, RestoreDatabaseDetails restoreDatabaseDetails, String ifMatch) {
        this.databaseId = databaseId;
        this.restoreDatabaseDetails = restoreDatabaseDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public RestoreDatabaseDetails getRestoreDatabaseDetails() {
        return this.restoreDatabaseDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String databaseId;
        private RestoreDatabaseDetails restoreDatabaseDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RestoreDatabaseRequest o) {
            this.databaseId(o.getDatabaseId());
            this.restoreDatabaseDetails(o.getRestoreDatabaseDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RestoreDatabaseRequest build() {
            RestoreDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder restoreDatabaseDetails(RestoreDatabaseDetails restoreDatabaseDetails) {
            this.restoreDatabaseDetails = restoreDatabaseDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public RestoreDatabaseRequest buildWithoutInvocationCallback() {
            return new RestoreDatabaseRequest(this.databaseId, this.restoreDatabaseDetails, this.ifMatch);
        }

        public String toString() {
            return "RestoreDatabaseRequest.Builder(databaseId=" + this.databaseId + ", restoreDatabaseDetails=" + this.restoreDatabaseDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

