/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import java.beans.ConstructorProperties;

public class ChangeDbSystemCompartmentResponse {
    private String etag;
    private String opcWorkRequestId;
    private String opcRequestId;

    @ConstructorProperties(value={"etag", "opcWorkRequestId", "opcRequestId"})
    ChangeDbSystemCompartmentResponse(String etag, String opcWorkRequestId, String opcRequestId) {
        this.etag = etag;
        this.opcWorkRequestId = opcWorkRequestId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String etag;
        private String opcWorkRequestId;
        private String opcRequestId;

        public Builder copy(ChangeDbSystemCompartmentResponse o) {
            this.etag(o.getEtag());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ChangeDbSystemCompartmentResponse build() {
            return new ChangeDbSystemCompartmentResponse(this.etag, this.opcWorkRequestId, this.opcRequestId);
        }

        public String toString() {
            return "ChangeDbSystemCompartmentResponse.Builder(etag=" + this.etag + ", opcWorkRequestId=" + this.opcWorkRequestId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

