/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.DbNode;
import java.beans.ConstructorProperties;

public class DbNodeActionResponse {
    private String etag;
    private String opcRequestId;
    private DbNode dbNode;

    @ConstructorProperties(value={"etag", "opcRequestId", "dbNode"})
    DbNodeActionResponse(String etag, String opcRequestId, DbNode dbNode) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.dbNode = dbNode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public DbNode getDbNode() {
        return this.dbNode;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private DbNode dbNode;

        public Builder copy(DbNodeActionResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.dbNode(o.getDbNode());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder dbNode(DbNode dbNode) {
            this.dbNode = dbNode;
            return this;
        }

        public DbNodeActionResponse build() {
            return new DbNodeActionResponse(this.etag, this.opcRequestId, this.dbNode);
        }

        public String toString() {
            return "DbNodeActionResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", dbNode=" + this.dbNode + ")";
        }
    }
}

