/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.AutonomousContainerDatabase;
import java.beans.ConstructorProperties;

public class GetAutonomousContainerDatabaseResponse {
    private String etag;
    private String opcRequestId;
    private AutonomousContainerDatabase autonomousContainerDatabase;

    @ConstructorProperties(value={"etag", "opcRequestId", "autonomousContainerDatabase"})
    GetAutonomousContainerDatabaseResponse(String etag, String opcRequestId, AutonomousContainerDatabase autonomousContainerDatabase) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.autonomousContainerDatabase = autonomousContainerDatabase;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AutonomousContainerDatabase getAutonomousContainerDatabase() {
        return this.autonomousContainerDatabase;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private AutonomousContainerDatabase autonomousContainerDatabase;

        public Builder copy(GetAutonomousContainerDatabaseResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.autonomousContainerDatabase(o.getAutonomousContainerDatabase());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder autonomousContainerDatabase(AutonomousContainerDatabase autonomousContainerDatabase) {
            this.autonomousContainerDatabase = autonomousContainerDatabase;
            return this;
        }

        public GetAutonomousContainerDatabaseResponse build() {
            return new GetAutonomousContainerDatabaseResponse(this.etag, this.opcRequestId, this.autonomousContainerDatabase);
        }

        public String toString() {
            return "GetAutonomousContainerDatabaseResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", autonomousContainerDatabase=" + this.autonomousContainerDatabase + ")";
        }
    }
}

