/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.VmCluster;
import java.beans.ConstructorProperties;

public class GetVmClusterResponse {
    private String etag;
    private String opcRequestId;
    private VmCluster vmCluster;

    @ConstructorProperties(value={"etag", "opcRequestId", "vmCluster"})
    GetVmClusterResponse(String etag, String opcRequestId, VmCluster vmCluster) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.vmCluster = vmCluster;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public VmCluster getVmCluster() {
        return this.vmCluster;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private VmCluster vmCluster;

        public Builder copy(GetVmClusterResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.vmCluster(o.getVmCluster());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder vmCluster(VmCluster vmCluster) {
            this.vmCluster = vmCluster;
            return this;
        }

        public GetVmClusterResponse build() {
            return new GetVmClusterResponse(this.etag, this.opcRequestId, this.vmCluster);
        }

        public String toString() {
            return "GetVmClusterResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", vmCluster=" + this.vmCluster + ")";
        }
    }
}

