/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.BackupDestinationSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListBackupDestinationResponse {
    private String etag;
    private String opcRequestId;
    private List<BackupDestinationSummary> items;

    @ConstructorProperties(value={"etag", "opcRequestId", "items"})
    ListBackupDestinationResponse(String etag, String opcRequestId, List<BackupDestinationSummary> items) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<BackupDestinationSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private List<BackupDestinationSummary> items;

        public Builder copy(ListBackupDestinationResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<BackupDestinationSummary> items) {
            this.items = items;
            return this;
        }

        public ListBackupDestinationResponse build() {
            return new ListBackupDestinationResponse(this.etag, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListBackupDestinationResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

