/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.BackupSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListBackupsResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<BackupSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListBackupsResponse(String opcRequestId, String opcNextPage, List<BackupSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<BackupSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<BackupSummary> items;

        public Builder copy(ListBackupsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<BackupSummary> items) {
            this.items = items;
            return this;
        }

        public ListBackupsResponse build() {
            return new ListBackupsResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListBackupsResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

