/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.PatchSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListDbSystemPatchesResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<PatchSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListDbSystemPatchesResponse(String opcRequestId, String opcNextPage, List<PatchSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<PatchSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<PatchSummary> items;

        public Builder copy(ListDbSystemPatchesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<PatchSummary> items) {
            this.items = items;
            return this;
        }

        public ListDbSystemPatchesResponse build() {
            return new ListDbSystemPatchesResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListDbSystemPatchesResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

