/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.ExadataInfrastructureSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListExadataInfrastructuresResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<ExadataInfrastructureSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListExadataInfrastructuresResponse(String opcRequestId, String opcNextPage, List<ExadataInfrastructureSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<ExadataInfrastructureSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<ExadataInfrastructureSummary> items;

        public Builder copy(ListExadataInfrastructuresResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<ExadataInfrastructureSummary> items) {
            this.items = items;
            return this;
        }

        public ListExadataInfrastructuresResponse build() {
            return new ListExadataInfrastructuresResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListExadataInfrastructuresResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

