/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.VmClusterNetworkSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListVmClusterNetworksResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<VmClusterNetworkSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListVmClusterNetworksResponse(String opcRequestId, String opcNextPage, List<VmClusterNetworkSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<VmClusterNetworkSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<VmClusterNetworkSummary> items;

        public Builder copy(ListVmClusterNetworksResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<VmClusterNetworkSummary> items) {
            this.items = items;
            return this;
        }

        public ListVmClusterNetworksResponse build() {
            return new ListVmClusterNetworksResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListVmClusterNetworksResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

