/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.AutonomousContainerDatabase;
import java.beans.ConstructorProperties;

public class RestartAutonomousContainerDatabaseResponse {
    private String etag;
    private String opcRequestId;
    private String opcWorkRequestId;
    private AutonomousContainerDatabase autonomousContainerDatabase;

    @ConstructorProperties(value={"etag", "opcRequestId", "opcWorkRequestId", "autonomousContainerDatabase"})
    RestartAutonomousContainerDatabaseResponse(String etag, String opcRequestId, String opcWorkRequestId, AutonomousContainerDatabase autonomousContainerDatabase) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.autonomousContainerDatabase = autonomousContainerDatabase;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public AutonomousContainerDatabase getAutonomousContainerDatabase() {
        return this.autonomousContainerDatabase;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private String opcWorkRequestId;
        private AutonomousContainerDatabase autonomousContainerDatabase;

        public Builder copy(RestartAutonomousContainerDatabaseResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.autonomousContainerDatabase(o.getAutonomousContainerDatabase());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder autonomousContainerDatabase(AutonomousContainerDatabase autonomousContainerDatabase) {
            this.autonomousContainerDatabase = autonomousContainerDatabase;
            return this;
        }

        public RestartAutonomousContainerDatabaseResponse build() {
            return new RestartAutonomousContainerDatabaseResponse(this.etag, this.opcRequestId, this.opcWorkRequestId, this.autonomousContainerDatabase);
        }

        public String toString() {
            return "RestartAutonomousContainerDatabaseResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", opcWorkRequestId=" + this.opcWorkRequestId + ", autonomousContainerDatabase=" + this.autonomousContainerDatabase + ")";
        }
    }
}

