/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.BackupDestination;
import java.beans.ConstructorProperties;

public class UpdateBackupDestinationResponse {
    private String etag;
    private String opcRequestId;
    private BackupDestination backupDestination;

    @ConstructorProperties(value={"etag", "opcRequestId", "backupDestination"})
    UpdateBackupDestinationResponse(String etag, String opcRequestId, BackupDestination backupDestination) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.backupDestination = backupDestination;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public BackupDestination getBackupDestination() {
        return this.backupDestination;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private BackupDestination backupDestination;

        public Builder copy(UpdateBackupDestinationResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.backupDestination(o.getBackupDestination());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder backupDestination(BackupDestination backupDestination) {
            this.backupDestination = backupDestination;
            return this;
        }

        public UpdateBackupDestinationResponse build() {
            return new UpdateBackupDestinationResponse(this.etag, this.opcRequestId, this.backupDestination);
        }

        public String toString() {
            return "UpdateBackupDestinationResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", backupDestination=" + this.backupDestination + ")";
        }
    }
}

