/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.Database;
import java.beans.ConstructorProperties;

public class UpdateDatabaseResponse {
    private String etag;
    private String opcRequestId;
    private Database database;

    @ConstructorProperties(value={"etag", "opcRequestId", "database"})
    UpdateDatabaseResponse(String etag, String opcRequestId, Database database) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.database = database;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Database getDatabase() {
        return this.database;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Database database;

        public Builder copy(UpdateDatabaseResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.database(o.getDatabase());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder database(Database database) {
            this.database = database;
            return this;
        }

        public UpdateDatabaseResponse build() {
            return new UpdateDatabaseResponse(this.etag, this.opcRequestId, this.database);
        }

        public String toString() {
            return "UpdateDatabaseResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", database=" + this.database + ")";
        }
    }
}

