/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.DbHome;
import java.beans.ConstructorProperties;

public class UpdateDbHomeResponse {
    private String etag;
    private String opcRequestId;
    private DbHome dbHome;

    @ConstructorProperties(value={"etag", "opcRequestId", "dbHome"})
    UpdateDbHomeResponse(String etag, String opcRequestId, DbHome dbHome) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.dbHome = dbHome;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public DbHome getDbHome() {
        return this.dbHome;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private DbHome dbHome;

        public Builder copy(UpdateDbHomeResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.dbHome(o.getDbHome());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder dbHome(DbHome dbHome) {
            this.dbHome = dbHome;
            return this;
        }

        public UpdateDbHomeResponse build() {
            return new UpdateDbHomeResponse(this.etag, this.opcRequestId, this.dbHome);
        }

        public String toString() {
            return "UpdateDbHomeResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", dbHome=" + this.dbHome + ")";
        }
    }
}

