/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.MaintenanceRun;
import java.beans.ConstructorProperties;

public class UpdateMaintenanceRunResponse {
    private String etag;
    private String opcRequestId;
    private MaintenanceRun maintenanceRun;

    @ConstructorProperties(value={"etag", "opcRequestId", "maintenanceRun"})
    UpdateMaintenanceRunResponse(String etag, String opcRequestId, MaintenanceRun maintenanceRun) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.maintenanceRun = maintenanceRun;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public MaintenanceRun getMaintenanceRun() {
        return this.maintenanceRun;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private MaintenanceRun maintenanceRun;

        public Builder copy(UpdateMaintenanceRunResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.maintenanceRun(o.getMaintenanceRun());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder maintenanceRun(MaintenanceRun maintenanceRun) {
            this.maintenanceRun = maintenanceRun;
            return this;
        }

        public UpdateMaintenanceRunResponse build() {
            return new UpdateMaintenanceRunResponse(this.etag, this.opcRequestId, this.maintenanceRun);
        }

        public String toString() {
            return "UpdateMaintenanceRunResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", maintenanceRun=" + this.maintenanceRun + ")";
        }
    }
}

