/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.VmClusterNetwork;
import java.beans.ConstructorProperties;

public class UpdateVmClusterNetworkResponse {
    private String etag;
    private String opcRequestId;
    private VmClusterNetwork vmClusterNetwork;

    @ConstructorProperties(value={"etag", "opcRequestId", "vmClusterNetwork"})
    UpdateVmClusterNetworkResponse(String etag, String opcRequestId, VmClusterNetwork vmClusterNetwork) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.vmClusterNetwork = vmClusterNetwork;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public VmClusterNetwork getVmClusterNetwork() {
        return this.vmClusterNetwork;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private VmClusterNetwork vmClusterNetwork;

        public Builder copy(UpdateVmClusterNetworkResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.vmClusterNetwork(o.getVmClusterNetwork());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder vmClusterNetwork(VmClusterNetwork vmClusterNetwork) {
            this.vmClusterNetwork = vmClusterNetwork;
            return this;
        }

        public UpdateVmClusterNetworkResponse build() {
            return new UpdateVmClusterNetworkResponse(this.etag, this.opcRequestId, this.vmClusterNetwork);
        }

        public String toString() {
            return "UpdateVmClusterNetworkResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", vmClusterNetwork=" + this.vmClusterNetwork + ")";
        }
    }
}

