/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dns.DnsAsync;
import com.oracle.bmc.dns.internal.http.ChangeSteeringPolicyCompartmentConverter;
import com.oracle.bmc.dns.internal.http.ChangeZoneCompartmentConverter;
import com.oracle.bmc.dns.internal.http.CreateSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.CreateSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.CreateZoneConverter;
import com.oracle.bmc.dns.internal.http.DeleteDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.DeleteRRSetConverter;
import com.oracle.bmc.dns.internal.http.DeleteSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.DeleteSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.DeleteZoneConverter;
import com.oracle.bmc.dns.internal.http.GetDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.GetRRSetConverter;
import com.oracle.bmc.dns.internal.http.GetSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.GetSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.GetZoneConverter;
import com.oracle.bmc.dns.internal.http.GetZoneRecordsConverter;
import com.oracle.bmc.dns.internal.http.ListSteeringPoliciesConverter;
import com.oracle.bmc.dns.internal.http.ListSteeringPolicyAttachmentsConverter;
import com.oracle.bmc.dns.internal.http.ListZonesConverter;
import com.oracle.bmc.dns.internal.http.PatchDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.PatchRRSetConverter;
import com.oracle.bmc.dns.internal.http.PatchZoneRecordsConverter;
import com.oracle.bmc.dns.internal.http.UpdateDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.UpdateRRSetConverter;
import com.oracle.bmc.dns.internal.http.UpdateSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.UpdateSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.UpdateZoneConverter;
import com.oracle.bmc.dns.internal.http.UpdateZoneRecordsConverter;
import com.oracle.bmc.dns.requests.ChangeSteeringPolicyCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeZoneCompartmentRequest;
import com.oracle.bmc.dns.requests.CreateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.CreateSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.CreateZoneRequest;
import com.oracle.bmc.dns.requests.DeleteDomainRecordsRequest;
import com.oracle.bmc.dns.requests.DeleteRRSetRequest;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.DeleteZoneRequest;
import com.oracle.bmc.dns.requests.GetDomainRecordsRequest;
import com.oracle.bmc.dns.requests.GetRRSetRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.GetZoneRecordsRequest;
import com.oracle.bmc.dns.requests.GetZoneRequest;
import com.oracle.bmc.dns.requests.ListSteeringPoliciesRequest;
import com.oracle.bmc.dns.requests.ListSteeringPolicyAttachmentsRequest;
import com.oracle.bmc.dns.requests.ListZonesRequest;
import com.oracle.bmc.dns.requests.PatchDomainRecordsRequest;
import com.oracle.bmc.dns.requests.PatchRRSetRequest;
import com.oracle.bmc.dns.requests.PatchZoneRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateDomainRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateRRSetRequest;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.UpdateZoneRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateZoneRequest;
import com.oracle.bmc.dns.responses.ChangeSteeringPolicyCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeZoneCompartmentResponse;
import com.oracle.bmc.dns.responses.CreateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.CreateSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.CreateZoneResponse;
import com.oracle.bmc.dns.responses.DeleteDomainRecordsResponse;
import com.oracle.bmc.dns.responses.DeleteRRSetResponse;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.DeleteZoneResponse;
import com.oracle.bmc.dns.responses.GetDomainRecordsResponse;
import com.oracle.bmc.dns.responses.GetRRSetResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.GetZoneRecordsResponse;
import com.oracle.bmc.dns.responses.GetZoneResponse;
import com.oracle.bmc.dns.responses.ListSteeringPoliciesResponse;
import com.oracle.bmc.dns.responses.ListSteeringPolicyAttachmentsResponse;
import com.oracle.bmc.dns.responses.ListZonesResponse;
import com.oracle.bmc.dns.responses.PatchDomainRecordsResponse;
import com.oracle.bmc.dns.responses.PatchRRSetResponse;
import com.oracle.bmc.dns.responses.PatchZoneRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateDomainRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateRRSetResponse;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.UpdateZoneRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateZoneResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsAsyncClient
implements DnsAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DnsAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DNS").serviceEndpointPrefix("dns").serviceEndpointTemplate("https://dns.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DnsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DnsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DnsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DnsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DnsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DnsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DnsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeSteeringPolicyCompartmentResponse> changeSteeringPolicyCompartment(ChangeSteeringPolicyCompartmentRequest request, AsyncHandler<ChangeSteeringPolicyCompartmentRequest, ChangeSteeringPolicyCompartmentResponse> handler) {
        LOG.trace("Called async changeSteeringPolicyCompartment");
        final ChangeSteeringPolicyCompartmentRequest interceptedRequest = ChangeSteeringPolicyCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeSteeringPolicyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeSteeringPolicyCompartmentResponse> transformer = ChangeSteeringPolicyCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeSteeringPolicyCompartmentRequest, ChangeSteeringPolicyCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeSteeringPolicyCompartmentRequest, ChangeSteeringPolicyCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeSteeringPolicyCompartmentRequest, ChangeSteeringPolicyCompartmentResponse> onSuccess = new SuccessConsumer<ChangeSteeringPolicyCompartmentRequest, ChangeSteeringPolicyCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeSteeringPolicyCompartmentRequest> onError = new ErrorConsumer<ChangeSteeringPolicyCompartmentRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.post(ib, interceptedRequest.getChangeSteeringPolicyCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeSteeringPolicyCompartmentRequest, ChangeSteeringPolicyCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeSteeringPolicyCompartmentRequest, ChangeSteeringPolicyCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeSteeringPolicyCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeSteeringPolicyCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeSteeringPolicyCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeSteeringPolicyCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.post(ib, interceptedRequest.getChangeSteeringPolicyCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeSteeringPolicyCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeZoneCompartmentResponse> changeZoneCompartment(ChangeZoneCompartmentRequest request, AsyncHandler<ChangeZoneCompartmentRequest, ChangeZoneCompartmentResponse> handler) {
        LOG.trace("Called async changeZoneCompartment");
        final ChangeZoneCompartmentRequest interceptedRequest = ChangeZoneCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeZoneCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeZoneCompartmentResponse> transformer = ChangeZoneCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeZoneCompartmentRequest, ChangeZoneCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeZoneCompartmentRequest, ChangeZoneCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeZoneCompartmentRequest, ChangeZoneCompartmentResponse> onSuccess = new SuccessConsumer<ChangeZoneCompartmentRequest, ChangeZoneCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeZoneCompartmentRequest> onError = new ErrorConsumer<ChangeZoneCompartmentRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.post(ib, interceptedRequest.getChangeZoneCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeZoneCompartmentRequest, ChangeZoneCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeZoneCompartmentRequest, ChangeZoneCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeZoneCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeZoneCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeZoneCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeZoneCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.post(ib, interceptedRequest.getChangeZoneCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeZoneCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateSteeringPolicyResponse> createSteeringPolicy(CreateSteeringPolicyRequest request, AsyncHandler<CreateSteeringPolicyRequest, CreateSteeringPolicyResponse> handler) {
        LOG.trace("Called async createSteeringPolicy");
        final CreateSteeringPolicyRequest interceptedRequest = CreateSteeringPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateSteeringPolicyResponse> transformer = CreateSteeringPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateSteeringPolicyRequest, CreateSteeringPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateSteeringPolicyRequest, CreateSteeringPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateSteeringPolicyRequest, CreateSteeringPolicyResponse> onSuccess = new SuccessConsumer<CreateSteeringPolicyRequest, CreateSteeringPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateSteeringPolicyRequest> onError = new ErrorConsumer<CreateSteeringPolicyRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.post(ib, interceptedRequest.getCreateSteeringPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateSteeringPolicyRequest, CreateSteeringPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateSteeringPolicyRequest, CreateSteeringPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateSteeringPolicyRequest> onError = handler == null ? null : new ErrorConsumer<CreateSteeringPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateSteeringPolicyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateSteeringPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.post(ib, interceptedRequest.getCreateSteeringPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateSteeringPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateSteeringPolicyAttachmentResponse> createSteeringPolicyAttachment(CreateSteeringPolicyAttachmentRequest request, AsyncHandler<CreateSteeringPolicyAttachmentRequest, CreateSteeringPolicyAttachmentResponse> handler) {
        LOG.trace("Called async createSteeringPolicyAttachment");
        final CreateSteeringPolicyAttachmentRequest interceptedRequest = CreateSteeringPolicyAttachmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateSteeringPolicyAttachmentResponse> transformer = CreateSteeringPolicyAttachmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateSteeringPolicyAttachmentRequest, CreateSteeringPolicyAttachmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateSteeringPolicyAttachmentRequest, CreateSteeringPolicyAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateSteeringPolicyAttachmentRequest, CreateSteeringPolicyAttachmentResponse> onSuccess = new SuccessConsumer<CreateSteeringPolicyAttachmentRequest, CreateSteeringPolicyAttachmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateSteeringPolicyAttachmentRequest> onError = new ErrorConsumer<CreateSteeringPolicyAttachmentRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.post(ib, interceptedRequest.getCreateSteeringPolicyAttachmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateSteeringPolicyAttachmentRequest, CreateSteeringPolicyAttachmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateSteeringPolicyAttachmentRequest, CreateSteeringPolicyAttachmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateSteeringPolicyAttachmentRequest> onError = handler == null ? null : new ErrorConsumer<CreateSteeringPolicyAttachmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateSteeringPolicyAttachmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateSteeringPolicyAttachmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.post(ib, interceptedRequest.getCreateSteeringPolicyAttachmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateSteeringPolicyAttachmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateZoneResponse> createZone(CreateZoneRequest request, AsyncHandler<CreateZoneRequest, CreateZoneResponse> handler) {
        LOG.trace("Called async createZone");
        final CreateZoneRequest interceptedRequest = CreateZoneConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateZoneConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateZoneResponse> transformer = CreateZoneConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateZoneRequest, CreateZoneResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateZoneRequest, CreateZoneResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateZoneRequest, CreateZoneResponse> onSuccess = new SuccessConsumer<CreateZoneRequest, CreateZoneResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateZoneRequest> onError = new ErrorConsumer<CreateZoneRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.post(ib, interceptedRequest.getCreateZoneDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateZoneRequest, CreateZoneResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateZoneRequest, CreateZoneResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateZoneRequest> onError = handler == null ? null : new ErrorConsumer<CreateZoneRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateZoneDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateZoneResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.post(ib, interceptedRequest.getCreateZoneDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateZoneResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteDomainRecordsResponse> deleteDomainRecords(DeleteDomainRecordsRequest request, AsyncHandler<DeleteDomainRecordsRequest, DeleteDomainRecordsResponse> handler) {
        LOG.trace("Called async deleteDomainRecords");
        final DeleteDomainRecordsRequest interceptedRequest = DeleteDomainRecordsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteDomainRecordsResponse> transformer = DeleteDomainRecordsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteDomainRecordsRequest, DeleteDomainRecordsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteDomainRecordsRequest, DeleteDomainRecordsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteDomainRecordsRequest, DeleteDomainRecordsResponse> onSuccess = new SuccessConsumer<DeleteDomainRecordsRequest, DeleteDomainRecordsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteDomainRecordsRequest> onError = new ErrorConsumer<DeleteDomainRecordsRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteDomainRecordsRequest, DeleteDomainRecordsResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteDomainRecordsRequest, DeleteDomainRecordsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteDomainRecordsRequest> onError = handler == null ? null : new ErrorConsumer<DeleteDomainRecordsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteDomainRecordsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteDomainRecordsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteRRSetResponse> deleteRRSet(DeleteRRSetRequest request, AsyncHandler<DeleteRRSetRequest, DeleteRRSetResponse> handler) {
        LOG.trace("Called async deleteRRSet");
        final DeleteRRSetRequest interceptedRequest = DeleteRRSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteRRSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteRRSetResponse> transformer = DeleteRRSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteRRSetRequest, DeleteRRSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteRRSetRequest, DeleteRRSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteRRSetRequest, DeleteRRSetResponse> onSuccess = new SuccessConsumer<DeleteRRSetRequest, DeleteRRSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteRRSetRequest> onError = new ErrorConsumer<DeleteRRSetRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteRRSetRequest, DeleteRRSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteRRSetRequest, DeleteRRSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteRRSetRequest> onError = handler == null ? null : new ErrorConsumer<DeleteRRSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteRRSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteRRSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteSteeringPolicyResponse> deleteSteeringPolicy(DeleteSteeringPolicyRequest request, AsyncHandler<DeleteSteeringPolicyRequest, DeleteSteeringPolicyResponse> handler) {
        LOG.trace("Called async deleteSteeringPolicy");
        final DeleteSteeringPolicyRequest interceptedRequest = DeleteSteeringPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteSteeringPolicyResponse> transformer = DeleteSteeringPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteSteeringPolicyRequest, DeleteSteeringPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteSteeringPolicyRequest, DeleteSteeringPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteSteeringPolicyRequest, DeleteSteeringPolicyResponse> onSuccess = new SuccessConsumer<DeleteSteeringPolicyRequest, DeleteSteeringPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteSteeringPolicyRequest> onError = new ErrorConsumer<DeleteSteeringPolicyRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteSteeringPolicyRequest, DeleteSteeringPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteSteeringPolicyRequest, DeleteSteeringPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteSteeringPolicyRequest> onError = handler == null ? null : new ErrorConsumer<DeleteSteeringPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteSteeringPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteSteeringPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteSteeringPolicyAttachmentResponse> deleteSteeringPolicyAttachment(DeleteSteeringPolicyAttachmentRequest request, AsyncHandler<DeleteSteeringPolicyAttachmentRequest, DeleteSteeringPolicyAttachmentResponse> handler) {
        LOG.trace("Called async deleteSteeringPolicyAttachment");
        final DeleteSteeringPolicyAttachmentRequest interceptedRequest = DeleteSteeringPolicyAttachmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteSteeringPolicyAttachmentResponse> transformer = DeleteSteeringPolicyAttachmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteSteeringPolicyAttachmentRequest, DeleteSteeringPolicyAttachmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteSteeringPolicyAttachmentRequest, DeleteSteeringPolicyAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteSteeringPolicyAttachmentRequest, DeleteSteeringPolicyAttachmentResponse> onSuccess = new SuccessConsumer<DeleteSteeringPolicyAttachmentRequest, DeleteSteeringPolicyAttachmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteSteeringPolicyAttachmentRequest> onError = new ErrorConsumer<DeleteSteeringPolicyAttachmentRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteSteeringPolicyAttachmentRequest, DeleteSteeringPolicyAttachmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteSteeringPolicyAttachmentRequest, DeleteSteeringPolicyAttachmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteSteeringPolicyAttachmentRequest> onError = handler == null ? null : new ErrorConsumer<DeleteSteeringPolicyAttachmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteSteeringPolicyAttachmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteSteeringPolicyAttachmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteZoneResponse> deleteZone(DeleteZoneRequest request, AsyncHandler<DeleteZoneRequest, DeleteZoneResponse> handler) {
        LOG.trace("Called async deleteZone");
        final DeleteZoneRequest interceptedRequest = DeleteZoneConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteZoneConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteZoneResponse> transformer = DeleteZoneConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteZoneRequest, DeleteZoneResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteZoneRequest, DeleteZoneResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteZoneRequest, DeleteZoneResponse> onSuccess = new SuccessConsumer<DeleteZoneRequest, DeleteZoneResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteZoneRequest> onError = new ErrorConsumer<DeleteZoneRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteZoneRequest, DeleteZoneResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteZoneRequest, DeleteZoneResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteZoneRequest> onError = handler == null ? null : new ErrorConsumer<DeleteZoneRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteZoneResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteZoneResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDomainRecordsResponse> getDomainRecords(GetDomainRecordsRequest request, AsyncHandler<GetDomainRecordsRequest, GetDomainRecordsResponse> handler) {
        LOG.trace("Called async getDomainRecords");
        final GetDomainRecordsRequest interceptedRequest = GetDomainRecordsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDomainRecordsResponse> transformer = GetDomainRecordsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDomainRecordsRequest, GetDomainRecordsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDomainRecordsRequest, GetDomainRecordsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDomainRecordsRequest, GetDomainRecordsResponse> onSuccess = new SuccessConsumer<GetDomainRecordsRequest, GetDomainRecordsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDomainRecordsRequest> onError = new ErrorConsumer<GetDomainRecordsRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDomainRecordsRequest, GetDomainRecordsResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDomainRecordsRequest, GetDomainRecordsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDomainRecordsRequest> onError = handler == null ? null : new ErrorConsumer<GetDomainRecordsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDomainRecordsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDomainRecordsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetRRSetResponse> getRRSet(GetRRSetRequest request, AsyncHandler<GetRRSetRequest, GetRRSetResponse> handler) {
        LOG.trace("Called async getRRSet");
        final GetRRSetRequest interceptedRequest = GetRRSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetRRSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetRRSetResponse> transformer = GetRRSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetRRSetRequest, GetRRSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetRRSetRequest, GetRRSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetRRSetRequest, GetRRSetResponse> onSuccess = new SuccessConsumer<GetRRSetRequest, GetRRSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetRRSetRequest> onError = new ErrorConsumer<GetRRSetRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetRRSetRequest, GetRRSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetRRSetRequest, GetRRSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetRRSetRequest> onError = handler == null ? null : new ErrorConsumer<GetRRSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetRRSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetRRSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetSteeringPolicyResponse> getSteeringPolicy(GetSteeringPolicyRequest request, AsyncHandler<GetSteeringPolicyRequest, GetSteeringPolicyResponse> handler) {
        LOG.trace("Called async getSteeringPolicy");
        final GetSteeringPolicyRequest interceptedRequest = GetSteeringPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetSteeringPolicyResponse> transformer = GetSteeringPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetSteeringPolicyRequest, GetSteeringPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetSteeringPolicyRequest, GetSteeringPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetSteeringPolicyRequest, GetSteeringPolicyResponse> onSuccess = new SuccessConsumer<GetSteeringPolicyRequest, GetSteeringPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetSteeringPolicyRequest> onError = new ErrorConsumer<GetSteeringPolicyRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetSteeringPolicyRequest, GetSteeringPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetSteeringPolicyRequest, GetSteeringPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetSteeringPolicyRequest> onError = handler == null ? null : new ErrorConsumer<GetSteeringPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetSteeringPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetSteeringPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetSteeringPolicyAttachmentResponse> getSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request, AsyncHandler<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> handler) {
        LOG.trace("Called async getSteeringPolicyAttachment");
        final GetSteeringPolicyAttachmentRequest interceptedRequest = GetSteeringPolicyAttachmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetSteeringPolicyAttachmentResponse> transformer = GetSteeringPolicyAttachmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> onSuccess = new SuccessConsumer<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetSteeringPolicyAttachmentRequest> onError = new ErrorConsumer<GetSteeringPolicyAttachmentRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetSteeringPolicyAttachmentRequest> onError = handler == null ? null : new ErrorConsumer<GetSteeringPolicyAttachmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetSteeringPolicyAttachmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetSteeringPolicyAttachmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetZoneResponse> getZone(GetZoneRequest request, AsyncHandler<GetZoneRequest, GetZoneResponse> handler) {
        LOG.trace("Called async getZone");
        final GetZoneRequest interceptedRequest = GetZoneConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetZoneConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetZoneResponse> transformer = GetZoneConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetZoneRequest, GetZoneResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetZoneRequest, GetZoneResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetZoneRequest, GetZoneResponse> onSuccess = new SuccessConsumer<GetZoneRequest, GetZoneResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetZoneRequest> onError = new ErrorConsumer<GetZoneRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetZoneRequest, GetZoneResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetZoneRequest, GetZoneResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetZoneRequest> onError = handler == null ? null : new ErrorConsumer<GetZoneRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetZoneResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetZoneResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetZoneRecordsResponse> getZoneRecords(GetZoneRecordsRequest request, AsyncHandler<GetZoneRecordsRequest, GetZoneRecordsResponse> handler) {
        LOG.trace("Called async getZoneRecords");
        final GetZoneRecordsRequest interceptedRequest = GetZoneRecordsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetZoneRecordsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetZoneRecordsResponse> transformer = GetZoneRecordsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetZoneRecordsRequest, GetZoneRecordsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetZoneRecordsRequest, GetZoneRecordsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetZoneRecordsRequest, GetZoneRecordsResponse> onSuccess = new SuccessConsumer<GetZoneRecordsRequest, GetZoneRecordsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetZoneRecordsRequest> onError = new ErrorConsumer<GetZoneRecordsRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetZoneRecordsRequest, GetZoneRecordsResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetZoneRecordsRequest, GetZoneRecordsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetZoneRecordsRequest> onError = handler == null ? null : new ErrorConsumer<GetZoneRecordsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetZoneRecordsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetZoneRecordsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListSteeringPoliciesResponse> listSteeringPolicies(ListSteeringPoliciesRequest request, AsyncHandler<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse> handler) {
        LOG.trace("Called async listSteeringPolicies");
        final ListSteeringPoliciesRequest interceptedRequest = ListSteeringPoliciesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListSteeringPoliciesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListSteeringPoliciesResponse> transformer = ListSteeringPoliciesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse> onSuccess = new SuccessConsumer<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListSteeringPoliciesRequest> onError = new ErrorConsumer<ListSteeringPoliciesRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListSteeringPoliciesRequest> onError = handler == null ? null : new ErrorConsumer<ListSteeringPoliciesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListSteeringPoliciesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListSteeringPoliciesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListSteeringPolicyAttachmentsResponse> listSteeringPolicyAttachments(ListSteeringPolicyAttachmentsRequest request, AsyncHandler<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse> handler) {
        LOG.trace("Called async listSteeringPolicyAttachments");
        final ListSteeringPolicyAttachmentsRequest interceptedRequest = ListSteeringPolicyAttachmentsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListSteeringPolicyAttachmentsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListSteeringPolicyAttachmentsResponse> transformer = ListSteeringPolicyAttachmentsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse> onSuccess = new SuccessConsumer<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListSteeringPolicyAttachmentsRequest> onError = new ErrorConsumer<ListSteeringPolicyAttachmentsRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListSteeringPolicyAttachmentsRequest> onError = handler == null ? null : new ErrorConsumer<ListSteeringPolicyAttachmentsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListSteeringPolicyAttachmentsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListSteeringPolicyAttachmentsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListZonesResponse> listZones(ListZonesRequest request, AsyncHandler<ListZonesRequest, ListZonesResponse> handler) {
        LOG.trace("Called async listZones");
        final ListZonesRequest interceptedRequest = ListZonesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListZonesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListZonesResponse> transformer = ListZonesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListZonesRequest, ListZonesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListZonesRequest, ListZonesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListZonesRequest, ListZonesResponse> onSuccess = new SuccessConsumer<ListZonesRequest, ListZonesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListZonesRequest> onError = new ErrorConsumer<ListZonesRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListZonesRequest, ListZonesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListZonesRequest, ListZonesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListZonesRequest> onError = handler == null ? null : new ErrorConsumer<ListZonesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListZonesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListZonesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<PatchDomainRecordsResponse> patchDomainRecords(PatchDomainRecordsRequest request, AsyncHandler<PatchDomainRecordsRequest, PatchDomainRecordsResponse> handler) {
        LOG.trace("Called async patchDomainRecords");
        final PatchDomainRecordsRequest interceptedRequest = PatchDomainRecordsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = PatchDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, PatchDomainRecordsResponse> transformer = PatchDomainRecordsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<PatchDomainRecordsRequest, PatchDomainRecordsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<PatchDomainRecordsRequest, PatchDomainRecordsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<PatchDomainRecordsRequest, PatchDomainRecordsResponse> onSuccess = new SuccessConsumer<PatchDomainRecordsRequest, PatchDomainRecordsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<PatchDomainRecordsRequest> onError = new ErrorConsumer<PatchDomainRecordsRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.patch(ib, interceptedRequest.getPatchDomainRecordsDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<PatchDomainRecordsRequest, PatchDomainRecordsResponse> onSuccess = handler == null ? null : new SuccessConsumer<PatchDomainRecordsRequest, PatchDomainRecordsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<PatchDomainRecordsRequest> onError = handler == null ? null : new ErrorConsumer<PatchDomainRecordsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.patch(ib, interceptedRequest.getPatchDomainRecordsDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, PatchDomainRecordsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.patch(ib, interceptedRequest.getPatchDomainRecordsDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, PatchDomainRecordsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<PatchRRSetResponse> patchRRSet(PatchRRSetRequest request, AsyncHandler<PatchRRSetRequest, PatchRRSetResponse> handler) {
        LOG.trace("Called async patchRRSet");
        final PatchRRSetRequest interceptedRequest = PatchRRSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = PatchRRSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, PatchRRSetResponse> transformer = PatchRRSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<PatchRRSetRequest, PatchRRSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<PatchRRSetRequest, PatchRRSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<PatchRRSetRequest, PatchRRSetResponse> onSuccess = new SuccessConsumer<PatchRRSetRequest, PatchRRSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<PatchRRSetRequest> onError = new ErrorConsumer<PatchRRSetRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.patch(ib, interceptedRequest.getPatchRRSetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<PatchRRSetRequest, PatchRRSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<PatchRRSetRequest, PatchRRSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<PatchRRSetRequest> onError = handler == null ? null : new ErrorConsumer<PatchRRSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.patch(ib, interceptedRequest.getPatchRRSetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, PatchRRSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.patch(ib, interceptedRequest.getPatchRRSetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, PatchRRSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<PatchZoneRecordsResponse> patchZoneRecords(PatchZoneRecordsRequest request, AsyncHandler<PatchZoneRecordsRequest, PatchZoneRecordsResponse> handler) {
        LOG.trace("Called async patchZoneRecords");
        final PatchZoneRecordsRequest interceptedRequest = PatchZoneRecordsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = PatchZoneRecordsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, PatchZoneRecordsResponse> transformer = PatchZoneRecordsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<PatchZoneRecordsRequest, PatchZoneRecordsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<PatchZoneRecordsRequest, PatchZoneRecordsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<PatchZoneRecordsRequest, PatchZoneRecordsResponse> onSuccess = new SuccessConsumer<PatchZoneRecordsRequest, PatchZoneRecordsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<PatchZoneRecordsRequest> onError = new ErrorConsumer<PatchZoneRecordsRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.patch(ib, interceptedRequest.getPatchZoneRecordsDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<PatchZoneRecordsRequest, PatchZoneRecordsResponse> onSuccess = handler == null ? null : new SuccessConsumer<PatchZoneRecordsRequest, PatchZoneRecordsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<PatchZoneRecordsRequest> onError = handler == null ? null : new ErrorConsumer<PatchZoneRecordsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.patch(ib, interceptedRequest.getPatchZoneRecordsDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, PatchZoneRecordsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.patch(ib, interceptedRequest.getPatchZoneRecordsDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, PatchZoneRecordsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateDomainRecordsResponse> updateDomainRecords(UpdateDomainRecordsRequest request, AsyncHandler<UpdateDomainRecordsRequest, UpdateDomainRecordsResponse> handler) {
        LOG.trace("Called async updateDomainRecords");
        final UpdateDomainRecordsRequest interceptedRequest = UpdateDomainRecordsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateDomainRecordsResponse> transformer = UpdateDomainRecordsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateDomainRecordsRequest, UpdateDomainRecordsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateDomainRecordsRequest, UpdateDomainRecordsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateDomainRecordsRequest, UpdateDomainRecordsResponse> onSuccess = new SuccessConsumer<UpdateDomainRecordsRequest, UpdateDomainRecordsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateDomainRecordsRequest> onError = new ErrorConsumer<UpdateDomainRecordsRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDomainRecordsDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateDomainRecordsRequest, UpdateDomainRecordsResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateDomainRecordsRequest, UpdateDomainRecordsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateDomainRecordsRequest> onError = handler == null ? null : new ErrorConsumer<UpdateDomainRecordsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateDomainRecordsDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateDomainRecordsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDomainRecordsDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateDomainRecordsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateRRSetResponse> updateRRSet(UpdateRRSetRequest request, AsyncHandler<UpdateRRSetRequest, UpdateRRSetResponse> handler) {
        LOG.trace("Called async updateRRSet");
        final UpdateRRSetRequest interceptedRequest = UpdateRRSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateRRSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateRRSetResponse> transformer = UpdateRRSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateRRSetRequest, UpdateRRSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateRRSetRequest, UpdateRRSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateRRSetRequest, UpdateRRSetResponse> onSuccess = new SuccessConsumer<UpdateRRSetRequest, UpdateRRSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateRRSetRequest> onError = new ErrorConsumer<UpdateRRSetRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateRRSetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateRRSetRequest, UpdateRRSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateRRSetRequest, UpdateRRSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateRRSetRequest> onError = handler == null ? null : new ErrorConsumer<UpdateRRSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateRRSetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateRRSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateRRSetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateRRSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateSteeringPolicyResponse> updateSteeringPolicy(UpdateSteeringPolicyRequest request, AsyncHandler<UpdateSteeringPolicyRequest, UpdateSteeringPolicyResponse> handler) {
        LOG.trace("Called async updateSteeringPolicy");
        final UpdateSteeringPolicyRequest interceptedRequest = UpdateSteeringPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateSteeringPolicyResponse> transformer = UpdateSteeringPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateSteeringPolicyRequest, UpdateSteeringPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateSteeringPolicyRequest, UpdateSteeringPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateSteeringPolicyRequest, UpdateSteeringPolicyResponse> onSuccess = new SuccessConsumer<UpdateSteeringPolicyRequest, UpdateSteeringPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateSteeringPolicyRequest> onError = new ErrorConsumer<UpdateSteeringPolicyRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSteeringPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateSteeringPolicyRequest, UpdateSteeringPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateSteeringPolicyRequest, UpdateSteeringPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateSteeringPolicyRequest> onError = handler == null ? null : new ErrorConsumer<UpdateSteeringPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateSteeringPolicyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateSteeringPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSteeringPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateSteeringPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateSteeringPolicyAttachmentResponse> updateSteeringPolicyAttachment(UpdateSteeringPolicyAttachmentRequest request, AsyncHandler<UpdateSteeringPolicyAttachmentRequest, UpdateSteeringPolicyAttachmentResponse> handler) {
        LOG.trace("Called async updateSteeringPolicyAttachment");
        final UpdateSteeringPolicyAttachmentRequest interceptedRequest = UpdateSteeringPolicyAttachmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateSteeringPolicyAttachmentResponse> transformer = UpdateSteeringPolicyAttachmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateSteeringPolicyAttachmentRequest, UpdateSteeringPolicyAttachmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateSteeringPolicyAttachmentRequest, UpdateSteeringPolicyAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateSteeringPolicyAttachmentRequest, UpdateSteeringPolicyAttachmentResponse> onSuccess = new SuccessConsumer<UpdateSteeringPolicyAttachmentRequest, UpdateSteeringPolicyAttachmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateSteeringPolicyAttachmentRequest> onError = new ErrorConsumer<UpdateSteeringPolicyAttachmentRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSteeringPolicyAttachmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateSteeringPolicyAttachmentRequest, UpdateSteeringPolicyAttachmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateSteeringPolicyAttachmentRequest, UpdateSteeringPolicyAttachmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateSteeringPolicyAttachmentRequest> onError = handler == null ? null : new ErrorConsumer<UpdateSteeringPolicyAttachmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateSteeringPolicyAttachmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateSteeringPolicyAttachmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSteeringPolicyAttachmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateSteeringPolicyAttachmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateZoneResponse> updateZone(UpdateZoneRequest request, AsyncHandler<UpdateZoneRequest, UpdateZoneResponse> handler) {
        LOG.trace("Called async updateZone");
        final UpdateZoneRequest interceptedRequest = UpdateZoneConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateZoneConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateZoneResponse> transformer = UpdateZoneConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateZoneRequest, UpdateZoneResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateZoneRequest, UpdateZoneResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateZoneRequest, UpdateZoneResponse> onSuccess = new SuccessConsumer<UpdateZoneRequest, UpdateZoneResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateZoneRequest> onError = new ErrorConsumer<UpdateZoneRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateZoneDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateZoneRequest, UpdateZoneResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateZoneRequest, UpdateZoneResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateZoneRequest> onError = handler == null ? null : new ErrorConsumer<UpdateZoneRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateZoneDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateZoneResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateZoneDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateZoneResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateZoneRecordsResponse> updateZoneRecords(UpdateZoneRecordsRequest request, AsyncHandler<UpdateZoneRecordsRequest, UpdateZoneRecordsResponse> handler) {
        LOG.trace("Called async updateZoneRecords");
        final UpdateZoneRecordsRequest interceptedRequest = UpdateZoneRecordsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateZoneRecordsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateZoneRecordsResponse> transformer = UpdateZoneRecordsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateZoneRecordsRequest, UpdateZoneRecordsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateZoneRecordsRequest, UpdateZoneRecordsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateZoneRecordsRequest, UpdateZoneRecordsResponse> onSuccess = new SuccessConsumer<UpdateZoneRecordsRequest, UpdateZoneRecordsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateZoneRecordsRequest> onError = new ErrorConsumer<UpdateZoneRecordsRequest>(this, interceptedRequest);
                    DnsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateZoneRecordsDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateZoneRecordsRequest, UpdateZoneRecordsResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateZoneRecordsRequest, UpdateZoneRecordsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateZoneRecordsRequest> onError = handler == null ? null : new ErrorConsumer<UpdateZoneRecordsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateZoneRecordsDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateZoneRecordsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DnsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateZoneRecordsDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateZoneRecordsResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DnsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public DnsAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new DnsAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

