/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.dns.Dns;
import com.oracle.bmc.dns.model.Record;
import com.oracle.bmc.dns.model.SteeringPolicyAttachmentSummary;
import com.oracle.bmc.dns.model.SteeringPolicySummary;
import com.oracle.bmc.dns.model.ZoneSummary;
import com.oracle.bmc.dns.requests.GetDomainRecordsRequest;
import com.oracle.bmc.dns.requests.GetRRSetRequest;
import com.oracle.bmc.dns.requests.GetZoneRecordsRequest;
import com.oracle.bmc.dns.requests.ListSteeringPoliciesRequest;
import com.oracle.bmc.dns.requests.ListSteeringPolicyAttachmentsRequest;
import com.oracle.bmc.dns.requests.ListZonesRequest;
import com.oracle.bmc.dns.responses.GetDomainRecordsResponse;
import com.oracle.bmc.dns.responses.GetRRSetResponse;
import com.oracle.bmc.dns.responses.GetZoneRecordsResponse;
import com.oracle.bmc.dns.responses.ListSteeringPoliciesResponse;
import com.oracle.bmc.dns.responses.ListSteeringPolicyAttachmentsResponse;
import com.oracle.bmc.dns.responses.ListZonesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class DnsPaginators {
    private final Dns client;

    public Iterable<GetDomainRecordsResponse> getDomainRecordsResponseIterator(final GetDomainRecordsRequest request) {
        return new ResponseIterable<GetDomainRecordsRequest.Builder, GetDomainRecordsRequest, GetDomainRecordsResponse>(new Supplier<GetDomainRecordsRequest.Builder>(){

            public GetDomainRecordsRequest.Builder get() {
                return GetDomainRecordsRequest.builder().copy(request);
            }
        }, new Function<GetDomainRecordsResponse, String>(){

            public String apply(GetDomainRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<GetDomainRecordsRequest.Builder>, GetDomainRecordsRequest>(){

            public GetDomainRecordsRequest apply(RequestBuilderAndToken<GetDomainRecordsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<GetDomainRecordsRequest, GetDomainRecordsResponse>(){

            public GetDomainRecordsResponse apply(GetDomainRecordsRequest request) {
                return DnsPaginators.this.client.getDomainRecords(request);
            }
        });
    }

    public Iterable<Record> getDomainRecordsRecordIterator(final GetDomainRecordsRequest request) {
        return new ResponseRecordIterable<GetDomainRecordsRequest.Builder, GetDomainRecordsRequest, GetDomainRecordsResponse, Record>(new Supplier<GetDomainRecordsRequest.Builder>(){

            public GetDomainRecordsRequest.Builder get() {
                return GetDomainRecordsRequest.builder().copy(request);
            }
        }, new Function<GetDomainRecordsResponse, String>(){

            public String apply(GetDomainRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<GetDomainRecordsRequest.Builder>, GetDomainRecordsRequest>(){

            public GetDomainRecordsRequest apply(RequestBuilderAndToken<GetDomainRecordsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<GetDomainRecordsRequest, GetDomainRecordsResponse>(){

            public GetDomainRecordsResponse apply(GetDomainRecordsRequest request) {
                return DnsPaginators.this.client.getDomainRecords(request);
            }
        }, new Function<GetDomainRecordsResponse, List<Record>>(){

            public List<Record> apply(GetDomainRecordsResponse response) {
                return response.getRecordCollection().getItems();
            }
        });
    }

    public Iterable<GetRRSetResponse> getRRSetResponseIterator(final GetRRSetRequest request) {
        return new ResponseIterable<GetRRSetRequest.Builder, GetRRSetRequest, GetRRSetResponse>(new Supplier<GetRRSetRequest.Builder>(){

            public GetRRSetRequest.Builder get() {
                return GetRRSetRequest.builder().copy(request);
            }
        }, new Function<GetRRSetResponse, String>(){

            public String apply(GetRRSetResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<GetRRSetRequest.Builder>, GetRRSetRequest>(){

            public GetRRSetRequest apply(RequestBuilderAndToken<GetRRSetRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<GetRRSetRequest, GetRRSetResponse>(){

            public GetRRSetResponse apply(GetRRSetRequest request) {
                return DnsPaginators.this.client.getRRSet(request);
            }
        });
    }

    public Iterable<Record> getRRSetRecordIterator(final GetRRSetRequest request) {
        return new ResponseRecordIterable<GetRRSetRequest.Builder, GetRRSetRequest, GetRRSetResponse, Record>(new Supplier<GetRRSetRequest.Builder>(){

            public GetRRSetRequest.Builder get() {
                return GetRRSetRequest.builder().copy(request);
            }
        }, new Function<GetRRSetResponse, String>(){

            public String apply(GetRRSetResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<GetRRSetRequest.Builder>, GetRRSetRequest>(){

            public GetRRSetRequest apply(RequestBuilderAndToken<GetRRSetRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<GetRRSetRequest, GetRRSetResponse>(){

            public GetRRSetResponse apply(GetRRSetRequest request) {
                return DnsPaginators.this.client.getRRSet(request);
            }
        }, new Function<GetRRSetResponse, List<Record>>(){

            public List<Record> apply(GetRRSetResponse response) {
                return response.getRRSet().getItems();
            }
        });
    }

    public Iterable<GetZoneRecordsResponse> getZoneRecordsResponseIterator(final GetZoneRecordsRequest request) {
        return new ResponseIterable<GetZoneRecordsRequest.Builder, GetZoneRecordsRequest, GetZoneRecordsResponse>(new Supplier<GetZoneRecordsRequest.Builder>(){

            public GetZoneRecordsRequest.Builder get() {
                return GetZoneRecordsRequest.builder().copy(request);
            }
        }, new Function<GetZoneRecordsResponse, String>(){

            public String apply(GetZoneRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<GetZoneRecordsRequest.Builder>, GetZoneRecordsRequest>(){

            public GetZoneRecordsRequest apply(RequestBuilderAndToken<GetZoneRecordsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<GetZoneRecordsRequest, GetZoneRecordsResponse>(){

            public GetZoneRecordsResponse apply(GetZoneRecordsRequest request) {
                return DnsPaginators.this.client.getZoneRecords(request);
            }
        });
    }

    public Iterable<Record> getZoneRecordsRecordIterator(final GetZoneRecordsRequest request) {
        return new ResponseRecordIterable<GetZoneRecordsRequest.Builder, GetZoneRecordsRequest, GetZoneRecordsResponse, Record>(new Supplier<GetZoneRecordsRequest.Builder>(){

            public GetZoneRecordsRequest.Builder get() {
                return GetZoneRecordsRequest.builder().copy(request);
            }
        }, new Function<GetZoneRecordsResponse, String>(){

            public String apply(GetZoneRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<GetZoneRecordsRequest.Builder>, GetZoneRecordsRequest>(){

            public GetZoneRecordsRequest apply(RequestBuilderAndToken<GetZoneRecordsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<GetZoneRecordsRequest, GetZoneRecordsResponse>(){

            public GetZoneRecordsResponse apply(GetZoneRecordsRequest request) {
                return DnsPaginators.this.client.getZoneRecords(request);
            }
        }, new Function<GetZoneRecordsResponse, List<Record>>(){

            public List<Record> apply(GetZoneRecordsResponse response) {
                return response.getRecordCollection().getItems();
            }
        });
    }

    public Iterable<ListSteeringPoliciesResponse> listSteeringPoliciesResponseIterator(final ListSteeringPoliciesRequest request) {
        return new ResponseIterable<ListSteeringPoliciesRequest.Builder, ListSteeringPoliciesRequest, ListSteeringPoliciesResponse>(new Supplier<ListSteeringPoliciesRequest.Builder>(){

            public ListSteeringPoliciesRequest.Builder get() {
                return ListSteeringPoliciesRequest.builder().copy(request);
            }
        }, new Function<ListSteeringPoliciesResponse, String>(){

            public String apply(ListSteeringPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListSteeringPoliciesRequest.Builder>, ListSteeringPoliciesRequest>(){

            public ListSteeringPoliciesRequest apply(RequestBuilderAndToken<ListSteeringPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse>(){

            public ListSteeringPoliciesResponse apply(ListSteeringPoliciesRequest request) {
                return DnsPaginators.this.client.listSteeringPolicies(request);
            }
        });
    }

    public Iterable<SteeringPolicySummary> listSteeringPoliciesRecordIterator(final ListSteeringPoliciesRequest request) {
        return new ResponseRecordIterable<ListSteeringPoliciesRequest.Builder, ListSteeringPoliciesRequest, ListSteeringPoliciesResponse, SteeringPolicySummary>(new Supplier<ListSteeringPoliciesRequest.Builder>(){

            public ListSteeringPoliciesRequest.Builder get() {
                return ListSteeringPoliciesRequest.builder().copy(request);
            }
        }, new Function<ListSteeringPoliciesResponse, String>(){

            public String apply(ListSteeringPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListSteeringPoliciesRequest.Builder>, ListSteeringPoliciesRequest>(){

            public ListSteeringPoliciesRequest apply(RequestBuilderAndToken<ListSteeringPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse>(){

            public ListSteeringPoliciesResponse apply(ListSteeringPoliciesRequest request) {
                return DnsPaginators.this.client.listSteeringPolicies(request);
            }
        }, new Function<ListSteeringPoliciesResponse, List<SteeringPolicySummary>>(){

            public List<SteeringPolicySummary> apply(ListSteeringPoliciesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSteeringPolicyAttachmentsResponse> listSteeringPolicyAttachmentsResponseIterator(final ListSteeringPolicyAttachmentsRequest request) {
        return new ResponseIterable<ListSteeringPolicyAttachmentsRequest.Builder, ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse>(new Supplier<ListSteeringPolicyAttachmentsRequest.Builder>(){

            public ListSteeringPolicyAttachmentsRequest.Builder get() {
                return ListSteeringPolicyAttachmentsRequest.builder().copy(request);
            }
        }, new Function<ListSteeringPolicyAttachmentsResponse, String>(){

            public String apply(ListSteeringPolicyAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListSteeringPolicyAttachmentsRequest.Builder>, ListSteeringPolicyAttachmentsRequest>(){

            public ListSteeringPolicyAttachmentsRequest apply(RequestBuilderAndToken<ListSteeringPolicyAttachmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse>(){

            public ListSteeringPolicyAttachmentsResponse apply(ListSteeringPolicyAttachmentsRequest request) {
                return DnsPaginators.this.client.listSteeringPolicyAttachments(request);
            }
        });
    }

    public Iterable<SteeringPolicyAttachmentSummary> listSteeringPolicyAttachmentsRecordIterator(final ListSteeringPolicyAttachmentsRequest request) {
        return new ResponseRecordIterable<ListSteeringPolicyAttachmentsRequest.Builder, ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse, SteeringPolicyAttachmentSummary>(new Supplier<ListSteeringPolicyAttachmentsRequest.Builder>(){

            public ListSteeringPolicyAttachmentsRequest.Builder get() {
                return ListSteeringPolicyAttachmentsRequest.builder().copy(request);
            }
        }, new Function<ListSteeringPolicyAttachmentsResponse, String>(){

            public String apply(ListSteeringPolicyAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListSteeringPolicyAttachmentsRequest.Builder>, ListSteeringPolicyAttachmentsRequest>(){

            public ListSteeringPolicyAttachmentsRequest apply(RequestBuilderAndToken<ListSteeringPolicyAttachmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse>(){

            public ListSteeringPolicyAttachmentsResponse apply(ListSteeringPolicyAttachmentsRequest request) {
                return DnsPaginators.this.client.listSteeringPolicyAttachments(request);
            }
        }, new Function<ListSteeringPolicyAttachmentsResponse, List<SteeringPolicyAttachmentSummary>>(){

            public List<SteeringPolicyAttachmentSummary> apply(ListSteeringPolicyAttachmentsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListZonesResponse> listZonesResponseIterator(final ListZonesRequest request) {
        return new ResponseIterable<ListZonesRequest.Builder, ListZonesRequest, ListZonesResponse>(new Supplier<ListZonesRequest.Builder>(){

            public ListZonesRequest.Builder get() {
                return ListZonesRequest.builder().copy(request);
            }
        }, new Function<ListZonesResponse, String>(){

            public String apply(ListZonesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListZonesRequest.Builder>, ListZonesRequest>(){

            public ListZonesRequest apply(RequestBuilderAndToken<ListZonesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListZonesRequest, ListZonesResponse>(){

            public ListZonesResponse apply(ListZonesRequest request) {
                return DnsPaginators.this.client.listZones(request);
            }
        });
    }

    public Iterable<ZoneSummary> listZonesRecordIterator(final ListZonesRequest request) {
        return new ResponseRecordIterable<ListZonesRequest.Builder, ListZonesRequest, ListZonesResponse, ZoneSummary>(new Supplier<ListZonesRequest.Builder>(){

            public ListZonesRequest.Builder get() {
                return ListZonesRequest.builder().copy(request);
            }
        }, new Function<ListZonesResponse, String>(){

            public String apply(ListZonesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListZonesRequest.Builder>, ListZonesRequest>(){

            public ListZonesRequest apply(RequestBuilderAndToken<ListZonesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListZonesRequest, ListZonesResponse>(){

            public ListZonesResponse apply(ListZonesRequest request) {
                return DnsPaginators.this.client.listZones(request);
            }
        }, new Function<ListZonesResponse, List<ZoneSummary>>(){

            public List<ZoneSummary> apply(ListZonesResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public DnsPaginators(Dns client) {
        this.client = client;
    }
}

