/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.dns.Dns;
import com.oracle.bmc.dns.model.SteeringPolicy;
import com.oracle.bmc.dns.model.SteeringPolicyAttachment;
import com.oracle.bmc.dns.model.Zone;
import com.oracle.bmc.dns.requests.GetSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.GetZoneRequest;
import com.oracle.bmc.dns.responses.GetSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.GetZoneResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class DnsWaiters {
    private final ExecutorService executorService;
    private final Dns client;

    public Waiter<GetSteeringPolicyRequest, GetSteeringPolicyResponse> forSteeringPolicy(GetSteeringPolicyRequest request, SteeringPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSteeringPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSteeringPolicyRequest, GetSteeringPolicyResponse> forSteeringPolicy(GetSteeringPolicyRequest request, SteeringPolicy.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSteeringPolicy(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetSteeringPolicyRequest, GetSteeringPolicyResponse> forSteeringPolicy(GetSteeringPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SteeringPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSteeringPolicy(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetSteeringPolicyRequest, GetSteeringPolicyResponse> forSteeringPolicy(BmcGenericWaiter waiter, GetSteeringPolicyRequest request, SteeringPolicy.LifecycleState ... targetStates) {
        final HashSet<SteeringPolicy.LifecycleState> targetStatesSet = new HashSet<SteeringPolicy.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetSteeringPolicyRequest, GetSteeringPolicyResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetSteeringPolicyRequest, GetSteeringPolicyResponse>(){

            public GetSteeringPolicyResponse apply(GetSteeringPolicyRequest request) {
                return DnsWaiters.this.client.getSteeringPolicy(request);
            }
        }, new Predicate<GetSteeringPolicyResponse>(){

            public boolean apply(GetSteeringPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getSteeringPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SteeringPolicy.LifecycleState.Deleted)), request);
    }

    public Waiter<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> forSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request, SteeringPolicyAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSteeringPolicyAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> forSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request, SteeringPolicyAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSteeringPolicyAttachment(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> forSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SteeringPolicyAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSteeringPolicyAttachment(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> forSteeringPolicyAttachment(BmcGenericWaiter waiter, GetSteeringPolicyAttachmentRequest request, SteeringPolicyAttachment.LifecycleState ... targetStates) {
        final HashSet<SteeringPolicyAttachment.LifecycleState> targetStatesSet = new HashSet<SteeringPolicyAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse>(){

            public GetSteeringPolicyAttachmentResponse apply(GetSteeringPolicyAttachmentRequest request) {
                return DnsWaiters.this.client.getSteeringPolicyAttachment(request);
            }
        }, new Predicate<GetSteeringPolicyAttachmentResponse>(){

            public boolean apply(GetSteeringPolicyAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getSteeringPolicyAttachment().getLifecycleState());
            }
        }, false), request);
    }

    public Waiter<GetZoneRequest, GetZoneResponse> forZone(GetZoneRequest request, Zone.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forZone(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetZoneRequest, GetZoneResponse> forZone(GetZoneRequest request, Zone.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forZone(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetZoneRequest, GetZoneResponse> forZone(GetZoneRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Zone.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forZone(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetZoneRequest, GetZoneResponse> forZone(BmcGenericWaiter waiter, GetZoneRequest request, Zone.LifecycleState ... targetStates) {
        final HashSet<Zone.LifecycleState> targetStatesSet = new HashSet<Zone.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetZoneRequest, GetZoneResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetZoneRequest, GetZoneResponse>(){

            public GetZoneResponse apply(GetZoneRequest request) {
                return DnsWaiters.this.client.getZone(request);
            }
        }, new Predicate<GetZoneResponse>(){

            public boolean apply(GetZoneResponse response) {
                return targetStatesSet.contains((Object)response.getZone().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Zone.LifecycleState.Deleted)), request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public DnsWaiters(ExecutorService executorService, Dns client) {
        this.executorService = executorService;
        this.client = client;
    }
}

