/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.RRSet;
import com.oracle.bmc.dns.requests.GetRRSetRequest;
import com.oracle.bmc.dns.responses.GetRRSetResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRRSetConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetRRSetConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetRRSetRequest interceptRequest(GetRRSetRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetRRSetRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDomain(), (String)"domain must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRtype(), (String)"rtype must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("zones").path(HttpUtils.encodePathSegment(request.getZoneNameOrId())).path("records").path(HttpUtils.encodePathSegment(request.getDomain())).path(HttpUtils.encodePathSegment(request.getRtype()));
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getZoneVersion() != null) {
            target = target.queryParam("zoneVersion", HttpUtils.attemptEncodeQueryParam(request.getZoneVersion()));
        }
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfNoneMatch() != null) {
            ib.header("If-None-Match", request.getIfNoneMatch());
        }
        if (request.getIfModifiedSince() != null) {
            ib.header("If-Modified-Since", request.getIfModifiedSince());
        }
        return ib;
    }

    public static Function<Response, GetRRSetResponse> fromResponse() {
        Function<Response, GetRRSetResponse> transformer = new Function<Response, GetRRSetResponse>(){

            public GetRRSetResponse apply(Response rawResponse) {
                Optional<List<String>> eTagHeader;
                Optional<List<String>> opcRequestIdHeader;
                Optional<List<String>> opcTotalItemsHeader;
                LOG.trace("Transform function invoked for GetRRSetResponse");
                Function<Response, WithHeaders<RRSet>> responseFn = RESPONSE_CONVERSION_FACTORY.create(RRSet.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetRRSetResponse.Builder builder = GetRRSetResponse.builder();
                builder.rRSet((RRSet)response.getItem());
                Optional<List<String>> opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                if ((opcTotalItemsHeader = HeaderUtils.get(headers, "opc-total-items")).isPresent()) {
                    builder.opcTotalItems(HeaderUtils.toValue("opc-total-items", (String)((List)opcTotalItemsHeader.get()).get(0), Integer.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((eTagHeader = HeaderUtils.get(headers, "ETag")).isPresent()) {
                    builder.eTag(HeaderUtils.toValue("ETag", (String)((List)eTagHeader.get()).get(0), String.class));
                }
                GetRRSetResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

