/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.SteeringPolicyAttachmentSummary;
import com.oracle.bmc.dns.requests.ListSteeringPolicyAttachmentsRequest;
import com.oracle.bmc.dns.responses.ListSteeringPolicyAttachmentsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSteeringPolicyAttachmentsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListSteeringPolicyAttachmentsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListSteeringPolicyAttachmentsRequest interceptRequest(ListSteeringPolicyAttachmentsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListSteeringPolicyAttachmentsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("steeringPolicyAttachments");
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        if (request.getId() != null) {
            target = target.queryParam("id", HttpUtils.attemptEncodeQueryParam(request.getId()));
        }
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", HttpUtils.attemptEncodeQueryParam(request.getDisplayName()));
        }
        if (request.getSteeringPolicyId() != null) {
            target = target.queryParam("steeringPolicyId", HttpUtils.attemptEncodeQueryParam(request.getSteeringPolicyId()));
        }
        if (request.getZoneId() != null) {
            target = target.queryParam("zoneId", HttpUtils.attemptEncodeQueryParam(request.getZoneId()));
        }
        if (request.getDomain() != null) {
            target = target.queryParam("domain", HttpUtils.attemptEncodeQueryParam(request.getDomain()));
        }
        if (request.getDomainContains() != null) {
            target = target.queryParam("domainContains", HttpUtils.attemptEncodeQueryParam(request.getDomainContains()));
        }
        if (request.getTimeCreatedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeCreatedGreaterThanOrEqualTo", HttpUtils.attemptEncodeQueryParam(request.getTimeCreatedGreaterThanOrEqualTo()));
        }
        if (request.getTimeCreatedLessThan() != null) {
            target = target.queryParam("timeCreatedLessThan", HttpUtils.attemptEncodeQueryParam(request.getTimeCreatedLessThan()));
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", HttpUtils.attemptEncodeQueryParam(request.getLifecycleState().getValue()));
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", HttpUtils.attemptEncodeQueryParam(request.getSortBy().getValue()));
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", HttpUtils.attemptEncodeQueryParam(request.getSortOrder().getValue()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, ListSteeringPolicyAttachmentsResponse> fromResponse() {
        Function<Response, ListSteeringPolicyAttachmentsResponse> transformer = new Function<Response, ListSteeringPolicyAttachmentsResponse>(){

            public ListSteeringPolicyAttachmentsResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                Optional<List<String>> opcTotalItemsHeader;
                LOG.trace("Transform function invoked for ListSteeringPolicyAttachmentsResponse");
                Function<Response, WithHeaders<List<SteeringPolicyAttachmentSummary>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<SteeringPolicyAttachmentSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListSteeringPolicyAttachmentsResponse.Builder builder = ListSteeringPolicyAttachmentsResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                if ((opcTotalItemsHeader = HeaderUtils.get(headers, "opc-total-items")).isPresent()) {
                    builder.opcTotalItems(HeaderUtils.toValue("opc-total-items", (String)((List)opcTotalItemsHeader.get()).get(0), Integer.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListSteeringPolicyAttachmentsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

