/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.ZoneSummary;
import com.oracle.bmc.dns.requests.ListZonesRequest;
import com.oracle.bmc.dns.responses.ListZonesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListZonesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListZonesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListZonesRequest interceptRequest(ListZonesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListZonesRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("zones");
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        if (request.getName() != null) {
            target = target.queryParam("name", HttpUtils.attemptEncodeQueryParam(request.getName()));
        }
        if (request.getNameContains() != null) {
            target = target.queryParam("nameContains", HttpUtils.attemptEncodeQueryParam(request.getNameContains()));
        }
        if (request.getZoneType() != null) {
            target = target.queryParam("zoneType", HttpUtils.attemptEncodeQueryParam(request.getZoneType().getValue()));
        }
        if (request.getTimeCreatedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeCreatedGreaterThanOrEqualTo", HttpUtils.attemptEncodeQueryParam(request.getTimeCreatedGreaterThanOrEqualTo()));
        }
        if (request.getTimeCreatedLessThan() != null) {
            target = target.queryParam("timeCreatedLessThan", HttpUtils.attemptEncodeQueryParam(request.getTimeCreatedLessThan()));
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", HttpUtils.attemptEncodeQueryParam(request.getLifecycleState().getValue()));
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", HttpUtils.attemptEncodeQueryParam(request.getSortBy().getValue()));
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", HttpUtils.attemptEncodeQueryParam(request.getSortOrder().getValue()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, ListZonesResponse> fromResponse() {
        Function<Response, ListZonesResponse> transformer = new Function<Response, ListZonesResponse>(){

            public ListZonesResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                Optional<List<String>> opcTotalItemsHeader;
                LOG.trace("Transform function invoked for ListZonesResponse");
                Function<Response, WithHeaders<List<ZoneSummary>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<ZoneSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListZonesResponse.Builder builder = ListZonesResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                if ((opcTotalItemsHeader = HeaderUtils.get(headers, "opc-total-items")).isPresent()) {
                    builder.opcTotalItems(HeaderUtils.toValue("opc-total-items", (String)((List)opcTotalItemsHeader.get()).get(0), Integer.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListZonesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

