/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.RecordCollection;
import com.oracle.bmc.dns.requests.UpdateRRSetRequest;
import com.oracle.bmc.dns.responses.UpdateRRSetResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateRRSetConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateRRSetConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateRRSetRequest interceptRequest(UpdateRRSetRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateRRSetRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDomain(), (String)"domain must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRtype(), (String)"rtype must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateRRSetDetails(), (String)"updateRRSetDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("zones").path(HttpUtils.encodePathSegment(request.getZoneNameOrId())).path("records").path(HttpUtils.encodePathSegment(request.getDomain())).path(HttpUtils.encodePathSegment(request.getRtype()));
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("If-Match", request.getIfMatch());
        }
        if (request.getIfUnmodifiedSince() != null) {
            ib.header("If-Unmodified-Since", request.getIfUnmodifiedSince());
        }
        return ib;
    }

    public static Function<Response, UpdateRRSetResponse> fromResponse() {
        Function<Response, UpdateRRSetResponse> transformer = new Function<Response, UpdateRRSetResponse>(){

            public UpdateRRSetResponse apply(Response rawResponse) {
                Optional<List<String>> eTagHeader;
                Optional<List<String>> opcRequestIdHeader;
                Optional<List<String>> opcTotalItemsHeader;
                LOG.trace("Transform function invoked for UpdateRRSetResponse");
                Function<Response, WithHeaders<RecordCollection>> responseFn = RESPONSE_CONVERSION_FACTORY.create(RecordCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateRRSetResponse.Builder builder = UpdateRRSetResponse.builder();
                builder.recordCollection((RecordCollection)response.getItem());
                Optional<List<String>> opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                if ((opcTotalItemsHeader = HeaderUtils.get(headers, "opc-total-items")).isPresent()) {
                    builder.opcTotalItems(HeaderUtils.toValue("opc-total-items", (String)((List)opcTotalItemsHeader.get()).get(0), Integer.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((eTagHeader = HeaderUtils.get(headers, "ETag")).isPresent()) {
                    builder.eTag(HeaderUtils.toValue("ETag", (String)((List)eTagHeader.get()).get(0), String.class));
                }
                UpdateRRSetResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

