/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.SteeringPolicy;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyRequest;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSteeringPolicyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateSteeringPolicyConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateSteeringPolicyRequest interceptRequest(UpdateSteeringPolicyRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateSteeringPolicyRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getSteeringPolicyId(), (String)"steeringPolicyId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateSteeringPolicyDetails(), (String)"updateSteeringPolicyDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("steeringPolicies").path(HttpUtils.encodePathSegment(request.getSteeringPolicyId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("If-Match", request.getIfMatch());
        }
        if (request.getIfUnmodifiedSince() != null) {
            ib.header("If-Unmodified-Since", request.getIfUnmodifiedSince());
        }
        return ib;
    }

    public static Function<Response, UpdateSteeringPolicyResponse> fromResponse() {
        Function<Response, UpdateSteeringPolicyResponse> transformer = new Function<Response, UpdateSteeringPolicyResponse>(){

            public UpdateSteeringPolicyResponse apply(Response rawResponse) {
                Optional<List<String>> eTagHeader;
                LOG.trace("Transform function invoked for UpdateSteeringPolicyResponse");
                Function<Response, WithHeaders<SteeringPolicy>> responseFn = RESPONSE_CONVERSION_FACTORY.create(SteeringPolicy.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateSteeringPolicyResponse.Builder builder = UpdateSteeringPolicyResponse.builder();
                builder.steeringPolicy((SteeringPolicy)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((eTagHeader = HeaderUtils.get(headers, "ETag")).isPresent()) {
                    builder.eTag(HeaderUtils.toValue("ETag", (String)((List)eTagHeader.get()).get(0), String.class));
                }
                UpdateSteeringPolicyResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

