/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.Zone;
import com.oracle.bmc.dns.requests.UpdateZoneRequest;
import com.oracle.bmc.dns.responses.UpdateZoneResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateZoneConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateZoneConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateZoneRequest interceptRequest(UpdateZoneRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateZoneRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateZoneDetails(), (String)"updateZoneDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("zones").path(HttpUtils.encodePathSegment(request.getZoneNameOrId()));
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("If-Match", request.getIfMatch());
        }
        if (request.getIfUnmodifiedSince() != null) {
            ib.header("If-Unmodified-Since", request.getIfUnmodifiedSince());
        }
        return ib;
    }

    public static Function<Response, UpdateZoneResponse> fromResponse() {
        Function<Response, UpdateZoneResponse> transformer = new Function<Response, UpdateZoneResponse>(){

            public UpdateZoneResponse apply(Response rawResponse) {
                Optional<List<String>> eTagHeader;
                LOG.trace("Transform function invoked for UpdateZoneResponse");
                Function<Response, WithHeaders<Zone>> responseFn = RESPONSE_CONVERSION_FACTORY.create(Zone.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateZoneResponse.Builder builder = UpdateZoneResponse.builder();
                builder.zone((Zone)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((eTagHeader = HeaderUtils.get(headers, "ETag")).isPresent()) {
                    builder.eTag(HeaderUtils.toValue("ETag", (String)((List)eTagHeader.get()).get(0), String.class));
                }
                UpdateZoneResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

