/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.dns.model.CreateZoneBaseDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateZoneRequest
extends BmcRequest {
    private CreateZoneBaseDetails createZoneDetails;
    private String compartmentId;

    @ConstructorProperties(value={"createZoneDetails", "compartmentId"})
    CreateZoneRequest(CreateZoneBaseDetails createZoneDetails, String compartmentId) {
        this.createZoneDetails = createZoneDetails;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateZoneBaseDetails getCreateZoneDetails() {
        return this.createZoneDetails;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder {
        private CreateZoneBaseDetails createZoneDetails;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateZoneRequest o) {
            this.createZoneDetails(o.getCreateZoneDetails());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateZoneRequest build() {
            CreateZoneRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createZoneDetails(CreateZoneBaseDetails createZoneDetails) {
            this.createZoneDetails = createZoneDetails;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public CreateZoneRequest buildWithoutInvocationCallback() {
            return new CreateZoneRequest(this.createZoneDetails, this.compartmentId);
        }

        public String toString() {
            return "CreateZoneRequest.Builder(createZoneDetails=" + this.createZoneDetails + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

