/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteSteeringPolicyRequest
extends BmcRequest {
    private String steeringPolicyId;
    private String ifMatch;
    private String ifUnmodifiedSince;

    @ConstructorProperties(value={"steeringPolicyId", "ifMatch", "ifUnmodifiedSince"})
    DeleteSteeringPolicyRequest(String steeringPolicyId, String ifMatch, String ifUnmodifiedSince) {
        this.steeringPolicyId = steeringPolicyId;
        this.ifMatch = ifMatch;
        this.ifUnmodifiedSince = ifUnmodifiedSince;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSteeringPolicyId() {
        return this.steeringPolicyId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public static class Builder {
        private String steeringPolicyId;
        private String ifMatch;
        private String ifUnmodifiedSince;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteSteeringPolicyRequest o) {
            this.steeringPolicyId(o.getSteeringPolicyId());
            this.ifMatch(o.getIfMatch());
            this.ifUnmodifiedSince(o.getIfUnmodifiedSince());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteSteeringPolicyRequest build() {
            DeleteSteeringPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder steeringPolicyId(String steeringPolicyId) {
            this.steeringPolicyId = steeringPolicyId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public DeleteSteeringPolicyRequest buildWithoutInvocationCallback() {
            return new DeleteSteeringPolicyRequest(this.steeringPolicyId, this.ifMatch, this.ifUnmodifiedSince);
        }

        public String toString() {
            return "DeleteSteeringPolicyRequest.Builder(steeringPolicyId=" + this.steeringPolicyId + ", ifMatch=" + this.ifMatch + ", ifUnmodifiedSince=" + this.ifUnmodifiedSince + ")";
        }
    }
}

