/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.dns.model.PatchDomainRecordsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class PatchDomainRecordsRequest
extends BmcRequest {
    private String zoneNameOrId;
    private String domain;
    private PatchDomainRecordsDetails patchDomainRecordsDetails;
    private String ifMatch;
    private String ifUnmodifiedSince;
    private String compartmentId;

    @ConstructorProperties(value={"zoneNameOrId", "domain", "patchDomainRecordsDetails", "ifMatch", "ifUnmodifiedSince", "compartmentId"})
    PatchDomainRecordsRequest(String zoneNameOrId, String domain, PatchDomainRecordsDetails patchDomainRecordsDetails, String ifMatch, String ifUnmodifiedSince, String compartmentId) {
        this.zoneNameOrId = zoneNameOrId;
        this.domain = domain;
        this.patchDomainRecordsDetails = patchDomainRecordsDetails;
        this.ifMatch = ifMatch;
        this.ifUnmodifiedSince = ifUnmodifiedSince;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getZoneNameOrId() {
        return this.zoneNameOrId;
    }

    public String getDomain() {
        return this.domain;
    }

    public PatchDomainRecordsDetails getPatchDomainRecordsDetails() {
        return this.patchDomainRecordsDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder {
        private String zoneNameOrId;
        private String domain;
        private PatchDomainRecordsDetails patchDomainRecordsDetails;
        private String ifMatch;
        private String ifUnmodifiedSince;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PatchDomainRecordsRequest o) {
            this.zoneNameOrId(o.getZoneNameOrId());
            this.domain(o.getDomain());
            this.patchDomainRecordsDetails(o.getPatchDomainRecordsDetails());
            this.ifMatch(o.getIfMatch());
            this.ifUnmodifiedSince(o.getIfUnmodifiedSince());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PatchDomainRecordsRequest build() {
            PatchDomainRecordsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder zoneNameOrId(String zoneNameOrId) {
            this.zoneNameOrId = zoneNameOrId;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder patchDomainRecordsDetails(PatchDomainRecordsDetails patchDomainRecordsDetails) {
            this.patchDomainRecordsDetails = patchDomainRecordsDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public PatchDomainRecordsRequest buildWithoutInvocationCallback() {
            return new PatchDomainRecordsRequest(this.zoneNameOrId, this.domain, this.patchDomainRecordsDetails, this.ifMatch, this.ifUnmodifiedSince, this.compartmentId);
        }

        public String toString() {
            return "PatchDomainRecordsRequest.Builder(zoneNameOrId=" + this.zoneNameOrId + ", domain=" + this.domain + ", patchDomainRecordsDetails=" + this.patchDomainRecordsDetails + ", ifMatch=" + this.ifMatch + ", ifUnmodifiedSince=" + this.ifUnmodifiedSince + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

