/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.dns.model.PatchZoneRecordsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class PatchZoneRecordsRequest
extends BmcRequest {
    private String zoneNameOrId;
    private PatchZoneRecordsDetails patchZoneRecordsDetails;
    private String ifMatch;
    private String ifUnmodifiedSince;
    private String compartmentId;

    @ConstructorProperties(value={"zoneNameOrId", "patchZoneRecordsDetails", "ifMatch", "ifUnmodifiedSince", "compartmentId"})
    PatchZoneRecordsRequest(String zoneNameOrId, PatchZoneRecordsDetails patchZoneRecordsDetails, String ifMatch, String ifUnmodifiedSince, String compartmentId) {
        this.zoneNameOrId = zoneNameOrId;
        this.patchZoneRecordsDetails = patchZoneRecordsDetails;
        this.ifMatch = ifMatch;
        this.ifUnmodifiedSince = ifUnmodifiedSince;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getZoneNameOrId() {
        return this.zoneNameOrId;
    }

    public PatchZoneRecordsDetails getPatchZoneRecordsDetails() {
        return this.patchZoneRecordsDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder {
        private String zoneNameOrId;
        private PatchZoneRecordsDetails patchZoneRecordsDetails;
        private String ifMatch;
        private String ifUnmodifiedSince;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PatchZoneRecordsRequest o) {
            this.zoneNameOrId(o.getZoneNameOrId());
            this.patchZoneRecordsDetails(o.getPatchZoneRecordsDetails());
            this.ifMatch(o.getIfMatch());
            this.ifUnmodifiedSince(o.getIfUnmodifiedSince());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PatchZoneRecordsRequest build() {
            PatchZoneRecordsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder zoneNameOrId(String zoneNameOrId) {
            this.zoneNameOrId = zoneNameOrId;
            return this;
        }

        public Builder patchZoneRecordsDetails(PatchZoneRecordsDetails patchZoneRecordsDetails) {
            this.patchZoneRecordsDetails = patchZoneRecordsDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public PatchZoneRecordsRequest buildWithoutInvocationCallback() {
            return new PatchZoneRecordsRequest(this.zoneNameOrId, this.patchZoneRecordsDetails, this.ifMatch, this.ifUnmodifiedSince, this.compartmentId);
        }

        public String toString() {
            return "PatchZoneRecordsRequest.Builder(zoneNameOrId=" + this.zoneNameOrId + ", patchZoneRecordsDetails=" + this.patchZoneRecordsDetails + ", ifMatch=" + this.ifMatch + ", ifUnmodifiedSince=" + this.ifUnmodifiedSince + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

