/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.dns.model.UpdateDomainRecordsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateDomainRecordsRequest
extends BmcRequest {
    private String zoneNameOrId;
    private String domain;
    private UpdateDomainRecordsDetails updateDomainRecordsDetails;
    private String ifMatch;
    private String ifUnmodifiedSince;
    private String compartmentId;

    @ConstructorProperties(value={"zoneNameOrId", "domain", "updateDomainRecordsDetails", "ifMatch", "ifUnmodifiedSince", "compartmentId"})
    UpdateDomainRecordsRequest(String zoneNameOrId, String domain, UpdateDomainRecordsDetails updateDomainRecordsDetails, String ifMatch, String ifUnmodifiedSince, String compartmentId) {
        this.zoneNameOrId = zoneNameOrId;
        this.domain = domain;
        this.updateDomainRecordsDetails = updateDomainRecordsDetails;
        this.ifMatch = ifMatch;
        this.ifUnmodifiedSince = ifUnmodifiedSince;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getZoneNameOrId() {
        return this.zoneNameOrId;
    }

    public String getDomain() {
        return this.domain;
    }

    public UpdateDomainRecordsDetails getUpdateDomainRecordsDetails() {
        return this.updateDomainRecordsDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder {
        private String zoneNameOrId;
        private String domain;
        private UpdateDomainRecordsDetails updateDomainRecordsDetails;
        private String ifMatch;
        private String ifUnmodifiedSince;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDomainRecordsRequest o) {
            this.zoneNameOrId(o.getZoneNameOrId());
            this.domain(o.getDomain());
            this.updateDomainRecordsDetails(o.getUpdateDomainRecordsDetails());
            this.ifMatch(o.getIfMatch());
            this.ifUnmodifiedSince(o.getIfUnmodifiedSince());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDomainRecordsRequest build() {
            UpdateDomainRecordsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder zoneNameOrId(String zoneNameOrId) {
            this.zoneNameOrId = zoneNameOrId;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder updateDomainRecordsDetails(UpdateDomainRecordsDetails updateDomainRecordsDetails) {
            this.updateDomainRecordsDetails = updateDomainRecordsDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public UpdateDomainRecordsRequest buildWithoutInvocationCallback() {
            return new UpdateDomainRecordsRequest(this.zoneNameOrId, this.domain, this.updateDomainRecordsDetails, this.ifMatch, this.ifUnmodifiedSince, this.compartmentId);
        }

        public String toString() {
            return "UpdateDomainRecordsRequest.Builder(zoneNameOrId=" + this.zoneNameOrId + ", domain=" + this.domain + ", updateDomainRecordsDetails=" + this.updateDomainRecordsDetails + ", ifMatch=" + this.ifMatch + ", ifUnmodifiedSince=" + this.ifUnmodifiedSince + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

