/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.SteeringPolicy;
import java.beans.ConstructorProperties;

public class CreateSteeringPolicyResponse {
    private String opcRequestId;
    private String eTag;
    private SteeringPolicy steeringPolicy;

    @ConstructorProperties(value={"opcRequestId", "eTag", "steeringPolicy"})
    CreateSteeringPolicyResponse(String opcRequestId, String eTag, SteeringPolicy steeringPolicy) {
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.steeringPolicy = steeringPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public SteeringPolicy getSteeringPolicy() {
        return this.steeringPolicy;
    }

    public static class Builder {
        private String opcRequestId;
        private String eTag;
        private SteeringPolicy steeringPolicy;

        public Builder copy(CreateSteeringPolicyResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.steeringPolicy(o.getSteeringPolicy());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder steeringPolicy(SteeringPolicy steeringPolicy) {
            this.steeringPolicy = steeringPolicy;
            return this;
        }

        public CreateSteeringPolicyResponse build() {
            return new CreateSteeringPolicyResponse(this.opcRequestId, this.eTag, this.steeringPolicy);
        }

        public String toString() {
            return "CreateSteeringPolicyResponse.Builder(opcRequestId=" + this.opcRequestId + ", eTag=" + this.eTag + ", steeringPolicy=" + this.steeringPolicy + ")";
        }
    }
}

