/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.RecordCollection;
import java.beans.ConstructorProperties;

public class GetDomainRecordsResponse {
    private String opcNextPage;
    private Integer opcTotalItems;
    private String opcRequestId;
    private String eTag;
    private RecordCollection recordCollection;

    @ConstructorProperties(value={"opcNextPage", "opcTotalItems", "opcRequestId", "eTag", "recordCollection"})
    GetDomainRecordsResponse(String opcNextPage, Integer opcTotalItems, String opcRequestId, String eTag, RecordCollection recordCollection) {
        this.opcNextPage = opcNextPage;
        this.opcTotalItems = opcTotalItems;
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.recordCollection = recordCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public Integer getOpcTotalItems() {
        return this.opcTotalItems;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public RecordCollection getRecordCollection() {
        return this.recordCollection;
    }

    public static class Builder {
        private String opcNextPage;
        private Integer opcTotalItems;
        private String opcRequestId;
        private String eTag;
        private RecordCollection recordCollection;

        public Builder copy(GetDomainRecordsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcTotalItems(o.getOpcTotalItems());
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.recordCollection(o.getRecordCollection());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcTotalItems(Integer opcTotalItems) {
            this.opcTotalItems = opcTotalItems;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder recordCollection(RecordCollection recordCollection) {
            this.recordCollection = recordCollection;
            return this;
        }

        public GetDomainRecordsResponse build() {
            return new GetDomainRecordsResponse(this.opcNextPage, this.opcTotalItems, this.opcRequestId, this.eTag, this.recordCollection);
        }

        public String toString() {
            return "GetDomainRecordsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcTotalItems=" + this.opcTotalItems + ", opcRequestId=" + this.opcRequestId + ", eTag=" + this.eTag + ", recordCollection=" + this.recordCollection + ")";
        }
    }
}

